/*
 * Decompiled with CFR 0.152.
 */
package com.hobb1t.xml2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XElement {
    private static final NumberFormat _nf = NumberFormat.getInstance(Locale.ROOT);
    private String _name;
    private String _data = "";
    private Vector<XElement> _subElements = new Vector();
    private HashMap<String, String> _attributes = new HashMap();

    public XElement(String name) {
        this._name = name;
    }

    public void setAttribute(String name, String value) {
        this._attributes.put(name, value);
    }

    public void setAttribute(String name, int value) {
        this._attributes.put(name, _nf.format(value));
    }

    public void setAttribute(String name, long value) {
        this._attributes.put(name, _nf.format(value));
    }

    public void setAttribute(String name, float value) {
        this._attributes.put(name, _nf.format(value));
    }

    public void setAttribute(String name, double value) {
        this._attributes.put(name, _nf.format(value));
    }

    public void setAttribute(String name, boolean value) {
        this._attributes.put(name, value ? "true" : "false");
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public boolean hasAttribute(String name) {
        return this._attributes.containsKey(name);
    }

    public String getAttribute(String name, String def) {
        if (this.hasAttribute(name)) {
            return this._attributes.get(name);
        }
        return def;
    }

    public int getAttribute(String name, int def) {
        if (this.hasAttribute(name)) {
            try {
                return _nf.parse(this._attributes.get(name)).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public long getAttribute(String name, long def) {
        if (this.hasAttribute(name)) {
            try {
                return _nf.parse(this._attributes.get(name)).longValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public float getAttribute(String name, float def) {
        if (this.hasAttribute(name)) {
            try {
                return _nf.parse(this._attributes.get(name)).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public double getAttribute(String name, double def) {
        if (this.hasAttribute(name)) {
            try {
                return _nf.parse(this._attributes.get(name)).doubleValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public boolean getAttribute(String name, boolean def) {
        if (this.hasAttribute(name)) {
            String value = this._attributes.get(name);
            if ("true".equals(value) || "True".equals(value)) {
                return true;
            }
            if ("false".equals(value) || "False".equals(value)) {
                return false;
            }
        }
        return def;
    }

    public void add(XElement element) {
        this._subElements.add(element);
    }

    public XElement[] getElements() {
        return this._subElements.toArray(new XElement[this._subElements.size()]);
    }

    public XElement[] getElements(String name) {
        Vector<XElement> ret = new Vector<XElement>();
        for (XElement e : this._subElements) {
            if (!e.getName().equals(name)) continue;
            ret.add(e);
        }
        return ret.toArray(new XElement[ret.size()]);
    }

    public XElement getFirstElement() {
        if (this._subElements.size() == 0) {
            return null;
        }
        return this._subElements.get(0);
    }

    public XElement getFirstElement(String name) {
        for (XElement e : this._subElements) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public boolean hasElements(String name) {
        for (XElement e : this._subElements) {
            if (!e.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public String getData() {
        return this._data;
    }

    public void setData(String data) {
        this._data = data;
    }

    public static XElement load(String uri) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            Document doc = parser.parse(uri);
            if (!doc.hasChildNodes() && 1 != doc.getChildNodes().getLength()) {
                throw new IOException("Unknown formatted XML file: " + uri);
            }
            return XElement.parseNode(doc.getChildNodes().item(0));
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            throw new IOException("Failed to parse XML.", ex);
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            throw new IOException("Failed to parse XML.", ex);
        }
    }

    public static XElement load(File file) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            Document doc = parser.parse(file);
            if (!doc.hasChildNodes() && 1 != doc.getChildNodes().getLength()) {
                throw new IOException("Unknown formatted XML file: " + file.getAbsolutePath());
            }
            return XElement.parseNode(doc.getChildNodes().item(0));
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            throw new IOException("Failed to parse XML.", ex);
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            throw new IOException("Failed to parse XML.", ex);
        }
    }

    public static XElement load(InputStream stream) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            Document doc = parser.parse(stream);
            if (!doc.hasChildNodes() && 1 != doc.getChildNodes().getLength()) {
                throw new IOException("Unknown formatted XML stream.");
            }
            return XElement.parseNode(doc.getChildNodes().item(0));
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            throw new IOException("Failed to parse XML.", ex);
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            throw new IOException("Failed to parse XML.", ex);
        }
    }

    public static XElement loadFromString(String xml) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        return XElement.load(stream);
    }

    private static XElement parseNode(Node n) {
        int i;
        String name = n.getNodeName();
        XElement ret = new XElement(name);
        if (n.hasAttributes()) {
            for (i = 0; i < n.getAttributes().getLength(); ++i) {
                ret.setAttribute(n.getAttributes().item(i).getNodeName(), n.getAttributes().item(i).getNodeValue());
            }
        }
        if (n.hasChildNodes()) {
            for (i = 0; i < n.getChildNodes().getLength(); ++i) {
                Node sub = n.getChildNodes().item(i);
                if (1 == sub.getNodeType()) {
                    ret.add(XElement.parseNode(n.getChildNodes().item(i)));
                    continue;
                }
                if (3 != sub.getNodeType()) continue;
                ret.setData(sub.getNodeValue());
            }
        }
        return ret;
    }

    public void save(String fileName) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.newDocument();
            doc.appendChild(this.createNode(doc));
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new File(fileName));
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Failed to store: " + fileName);
        }
    }

    public void save(OutputStream stream) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.newDocument();
            doc.appendChild(this.createNode(doc));
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(stream);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Failed to store XML.");
        }
    }

    public String saveToString() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.save(stream);
        return stream.toString("UTF-8");
    }

    private Node createNode(Document doc) {
        Element n = doc.createElement(this._name);
        n.setTextContent(this._data);
        for (String key : this._attributes.keySet()) {
            n.setAttribute(key, this._attributes.get(key));
        }
        for (XElement sub : this._subElements) {
            n.appendChild(sub.createNode(doc));
        }
        return n;
    }

    public String toString() {
        return String.format("%s: %d attributes, %d subElements", this._name, this._attributes.keySet().size(), this._subElements.size());
    }

    static {
        _nf.setGroupingUsed(false);
    }
}

