/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.swt;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.WString;

public class Win7AppId {
    public static void setApplicationId(String applicationId) {
        AppId.setCurrentProcessExplicitAppUserModelID(applicationId);
    }

    private static class AppId {
        private AppId() {
        }

        private static boolean isValidOs() {
            if (!Platform.isWindows()) {
                return false;
            }
            int major = Kernel32.getMajorVersion();
            int minor = Kernel32.getMinorVersion();
            return major > 6 || major == 6 && minor >= 1;
        }

        public static void setCurrentProcessExplicitAppUserModelID(String appID) {
            if (AppId.isValidOs() && AppId.SetCurrentProcessExplicitAppUserModelID(new WString(appID)).longValue() != 0L) {
                throw new RuntimeException("unable to set current process explicit AppUserModelID to: " + appID);
            }
        }

        private static native NativeLong SetCurrentProcessExplicitAppUserModelID(WString var0);

        static {
            if (AppId.isValidOs()) {
                Native.register((String)"shell32");
            }
        }
    }

    private static class Kernel32 {
        private Kernel32() {
        }

        public static int getMajorVersion() {
            if (Platform.isWindows()) {
                return Kernel32.GetVersion() & 0xFF;
            }
            return 0;
        }

        public static int getMinorVersion() {
            if (Platform.isWindows()) {
                return (Kernel32.GetVersion() & 0xFF00) >> 8;
            }
            return 0;
        }

        private static native int GetVersion();

        static {
            if (Platform.isWindows()) {
                Native.register((String)"kernel32");
            }
        }
    }
}

