/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.utils;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.WString;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class Utils {
    public static void setApplicationId(String applicationId) {
        AppId.setCurrentProcessExplicitAppUserModelID(applicationId);
    }

    public static int getDialogStyle() {
        return 67696;
    }

    public static void centerOnParent(Shell child, Shell parent) {
        Rectangle childRect = child.getBounds();
        Rectangle parentRect = parent.getBounds();
        int x = parentRect.x + (parentRect.width - childRect.width) / 2;
        int y = parentRect.y + (parentRect.height - childRect.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        child.setLocation(x, y);
    }

    public static void showExceptionBox(Shell parent, String problem, Throwable ex) {
        Utils.showErrorDialog(parent, problem + " (" + ex.getLocalizedMessage() + ")");
    }

    public static void showErrorDialog(Shell parent, String text) {
        MessageBox dialog = new MessageBox(parent, 33);
        dialog.setText("Error");
        dialog.setMessage(text);
        dialog.open();
    }

    public static void showWarningDialog(Shell parent, String text) {
        MessageBox dialog = new MessageBox(parent, 40);
        dialog.setText("Warning");
        dialog.setMessage(text);
        dialog.open();
    }

    public static void showInfoDialog(Shell parent, String text) {
        MessageBox dialog = new MessageBox(parent, 34);
        dialog.setText("Information");
        dialog.setMessage(text);
        dialog.open();
    }

    public static boolean showYesNoDialog(Shell parent, String text) {
        MessageBox dialog = new MessageBox(parent, 196);
        dialog.setText("Question");
        dialog.setMessage(text);
        return dialog.open() == 64;
    }

    public static String showFileOpenDialog(Shell parent, String message, String[] extensions) {
        FileDialog dlg = new FileDialog(parent, 4096);
        dlg.setFilterExtensions(extensions);
        dlg.setText(message);
        return dlg.open();
    }

    public static String showFileSaveDialog(Shell parent, String message, String[] extensions) {
        FileDialog dlg = new FileDialog(parent, 8192);
        dlg.setFilterExtensions(extensions);
        dlg.setText(message);
        return dlg.open();
    }

    public static String showFolderSelectionDialog(Shell parent, String message) {
        DirectoryDialog dlg = new DirectoryDialog(parent);
        dlg.setMessage(message);
        return dlg.open();
    }

    private static class AppId {
        private AppId() {
        }

        private static boolean isValidOs() {
            if (!Platform.isWindows()) {
                return false;
            }
            int major = Kernel32.getMajorVersion();
            int minor = Kernel32.getMinorVersion();
            return major > 6 || major == 6 && minor >= 1;
        }

        public static void setCurrentProcessExplicitAppUserModelID(String appID) {
            if (AppId.isValidOs() && AppId.SetCurrentProcessExplicitAppUserModelID(new WString(appID)).longValue() != 0L) {
                throw new RuntimeException("unable to set current process explicit AppUserModelID to: " + appID);
            }
        }

        private static native NativeLong SetCurrentProcessExplicitAppUserModelID(WString var0);

        static {
            if (AppId.isValidOs()) {
                Native.register((String)"shell32");
            }
        }
    }

    private static class Kernel32 {
        private Kernel32() {
        }

        public static int getMajorVersion() {
            if (Platform.isWindows()) {
                return Kernel32.GetVersion() & 0xFF;
            }
            return 0;
        }

        public static int getMinorVersion() {
            if (Platform.isWindows()) {
                return (Kernel32.GetVersion() & 0xFF00) >> 8;
            }
            return 0;
        }

        private static native int GetVersion();

        static {
            if (Platform.isWindows()) {
                Native.register((String)"kernel32");
            }
        }
    }
}

