/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.processing;

import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.apps.cebomultilogger.utils.Utils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class PT1000Dlg
extends Dialog {
    private int _unit;
    private double _current;
    protected boolean _result = false;
    protected Shell _shell;
    private Label _label;
    private Combo _cmbSelection;
    private Button _btnOK;
    private Button _btnCancel;
    private Composite _composite;
    private Label _label_1;
    private Text _txtCurrent;
    private Combo _cmbCUnit;

    public int getUnit() {
        return this._unit;
    }

    public double getCurrent() {
        return this._current;
    }

    public PT1000Dlg(Shell parent, int unit, double current) {
        super(parent, Utils.getDialogStyle());
        this._unit = unit;
        this._current = current;
    }

    public boolean open() {
        this.createContents();
        this._shell.pack();
        Utils.centerOnParent(this._shell, this.getParent());
        this._shell.open();
        this._shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this._result;
    }

    private void createContents() {
        this._shell = new Shell(this.getParent(), this.getStyle());
        this._shell.setImage(SWTResourceManager.getImage(PT1000Dlg.class, "/com/cesys/apps/cebomultilogger/resources/Component.png"));
        this._shell.setSize(337, 149);
        this._shell.setText("PT 1000 configuration");
        GridLayout gl_shell = new GridLayout();
        gl_shell.numColumns = 3;
        this._shell.setLayout((Layout)gl_shell);
        this._label = new Label((Composite)this._shell, 0);
        this._label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label.setText("Target unit:");
        this._cmbSelection = new Combo((Composite)this._shell, 8);
        this._cmbSelection.setItems(new String[]{"Degree Celsius (\u00b0C)", "Kelvin (K)", "Degree Fahrenheit (\u00b0F)"});
        this._cmbSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._cmbSelection.select(this._unit);
        this._label_1 = new Label((Composite)this._shell, 0);
        this._label_1.setText("Reference current:");
        this._composite = new Composite((Composite)this._shell, 0);
        this._composite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        this._composite.setLayout((Layout)gl_composite);
        this._txtCurrent = new Text(this._composite, 2048);
        this._txtCurrent.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._txtCurrent.setText(NumberSupport.UI.format(this._current * 1000.0));
        this._txtCurrent.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String v = PT1000Dlg.this._txtCurrent.getText();
                if (NumberSupport.UI.isValidNumber(v) && NumberSupport.UI.asDoubleNE(v) != 0.0) {
                    PT1000Dlg.this._btnOK.setEnabled(true);
                    PT1000Dlg.this._txtCurrent.setForeground(PT1000Dlg.this._shell.getDisplay().getSystemColor(21));
                    PT1000Dlg.this._current = NumberSupport.UI.asDoubleNE(PT1000Dlg.this._txtCurrent.getText());
                    if (PT1000Dlg.this._cmbCUnit.getSelectionIndex() == 0) {
                        PT1000Dlg.this._current = PT1000Dlg.this._current / 1000.0;
                    }
                } else {
                    PT1000Dlg.this._btnOK.setEnabled(false);
                    PT1000Dlg.this._txtCurrent.setForeground(SWTResourceManager.getColor(255, 0, 0));
                }
            }
        });
        this._cmbCUnit = new Combo(this._composite, 8);
        this._cmbCUnit.setItems(new String[]{"mA", "A"});
        this._cmbCUnit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this._cmbCUnit.select(0);
        this._cmbCUnit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PT1000Dlg.this._txtCurrent.setText(NumberSupport.UI.format(PT1000Dlg.this._cmbCUnit.getSelectionIndex() == 0 ? PT1000Dlg.this._current * 1000.0 : PT1000Dlg.this._current));
            }
        });
        new Label((Composite)this._shell, 0);
        this._btnOK = new Button((Composite)this._shell, 0);
        this._btnOK.setImage(SWTResourceManager.getImage(PT1000Dlg.class, "/com/cesys/apps/cebomultilogger/resources/OK.png"));
        this._btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PT1000Dlg.this._unit = PT1000Dlg.this._cmbSelection.getSelectionIndex();
                PT1000Dlg.this._result = true;
                PT1000Dlg.this._shell.close();
            }
        });
        GridData gd_btnOK = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_btnOK.widthHint = 120;
        this._btnOK.setLayoutData((Object)gd_btnOK);
        this._btnOK.setText("OK");
        this._btnCancel = new Button((Composite)this._shell, 0);
        this._btnCancel.setImage(SWTResourceManager.getImage(PT1000Dlg.class, "/com/cesys/apps/cebomultilogger/resources/Cancel.png"));
        this._btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PT1000Dlg.this._shell.close();
            }
        });
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = 120;
        this._btnCancel.setLayoutData((Object)gd_btnCancel);
        this._btnCancel.setText("Cancel");
    }
}

