/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.processing;

import com.cesys.apps.cebomultilogger.Curve2D;
import com.cesys.apps.cebomultilogger.Point2D;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IProcessing;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.apps.cebomultilogger.plugins.ProcessingCategories;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import com.cesys.apps.cebomultilogger.processing.PT1000Dlg;
import com.hobb1t.xml2.XElement;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class PT1000
implements IProcessing {
    private final Curve2D _curve;
    private int _unit = 0;
    private double _current = 0.1;

    public PT1000() {
        double[] res = new double[]{803.1, 822.9, 842.7, 862.5, 882.2, 901.9, 921.6, 941.2, 960.9, 980.4, 1000.0, 1019.5, 1039.0, 1058.5, 1077.9, 1097.3, 1116.7, 1136.1, 1155.4, 1174.7, 1194.0, 1214.9, 1232.4, 1251.6, 1270.7, 1289.8, 1308.9, 1328.0, 1347.0, 1366.0, 1385.0, 1403.9, 1422.9, 1573.1, 1758.4};
        this._curve = new Curve2D();
        this._curve.setExtrapolate(true);
        for (int i = 0; i < res.length; ++i) {
            int temp = -50 + i * 5;
            if (temp == 115) {
                temp = 150;
            }
            if (temp == 120) {
                temp = 200;
            }
            this._curve.addPoint(new Point2D(res[i], temp));
        }
    }

    @Override
    public String getTypeName() {
        return "PT1000";
    }

    @Override
    public String getName() {
        return "PT 1000";
    }

    @Override
    public String getParamInfo() {
        String cur = NumberSupport.UI.toUnitString(this._current * 1000.0, "mA");
        switch (this._unit) {
            case 0: {
                return "\u00b0C, " + cur;
            }
            case 1: {
                return "K, " + cur;
            }
            case 2: {
                return "\u00b0F, " + cur;
            }
        }
        return "?";
    }

    @Override
    public ProcessingCategories getCategory() {
        return ProcessingCategories.ANALOG_CONVERSION;
    }

    @Override
    public IProcessing createInstance() {
        return new PT1000();
    }

    @Override
    public Sample transformValue(Sample value, long timeStamp, IDevice device, boolean live) {
        double r = value.getNumber().doubleValue() / this._current;
        double celcius = this._curve.mapXtoY(r);
        switch (this._unit) {
            case 0: {
                return new Sample(celcius, "\u00b0C");
            }
            case 1: {
                return new Sample(celcius + 273.15, "K");
            }
            case 2: {
                return new Sample(celcius * 1.8 + 32.0, "\u00b0F");
            }
        }
        throw new RuntimeException("Invalid parameter.");
    }

    @Override
    public boolean hasConfiguration() {
        return true;
    }

    @Override
    public boolean configure(Shell parent) {
        PT1000Dlg dlg = new PT1000Dlg(parent, this._unit, this._current);
        if (dlg.open()) {
            this._unit = dlg.getUnit();
            this._current = dlg.getCurrent();
            return true;
        }
        return false;
    }

    @Override
    public List<XElement> getConfig() {
        XElement x = new XElement("config");
        x.setAttribute("unit", this._unit);
        x.setAttribute("current", this._current);
        return Arrays.asList(x);
    }

    @Override
    public void setConfig(List<XElement> config) {
        for (XElement x : config) {
            this._unit = x.getAttribute("unit", 0);
            this._current = x.getAttribute("current", 1.0);
        }
    }
}

