/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.processing;

import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.apps.cebomultilogger.processing.PT1000Dlg;
import com.cesys.apps.cebomultilogger.utils.Utils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class FrequencyAnalyzerDlg
extends Dialog {
    private double _lower;
    private double _upper;
    private int _lookupSize;
    protected boolean _result = false;
    protected Shell _shell;
    private Button _btnOK;
    private Button _btnCancel;
    private Label _label;
    private Label _label_1;
    private Label _label_2;
    private Text _txtLower;
    private Text _txtUpper;
    private Composite _composite;
    private Label _label_3;
    private Label _label_4;
    private Spinner _spnLookupSize;

    public double getLower() {
        return this._lower;
    }

    public double getUpper() {
        return this._upper;
    }

    public int getLookupSize() {
        return this._lookupSize;
    }

    public FrequencyAnalyzerDlg(Shell parent, double lower, double upper, int lookupSize) {
        super(parent, Utils.getDialogStyle());
        this._lower = lower;
        this._upper = upper;
        this._lookupSize = lookupSize;
    }

    public boolean open() {
        this.createContents();
        this._shell.pack();
        Utils.centerOnParent(this._shell, this.getParent());
        this._shell.open();
        this._shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this._result;
    }

    private void createContents() {
        this._shell = new Shell(this.getParent(), this.getStyle());
        this._shell.setImage(SWTResourceManager.getImage(FrequencyAnalyzerDlg.class, "/com/cesys/apps/cebomultilogger/resources/Component.png"));
        this._shell.setSize(450, 300);
        this._shell.setText("Frequency Analyzer configuration");
        GridLayout gl_shell = new GridLayout();
        gl_shell.numColumns = 3;
        this._shell.setLayout((Layout)gl_shell);
        this._label = new Label((Composite)this._shell, 0);
        this._label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label.setText("Lower voltage:");
        this._txtLower = new Text((Composite)this._shell, 2048);
        GridData gd_txtLower = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtLower.widthHint = 200;
        this._txtLower.setLayoutData((Object)gd_txtLower);
        this._txtLower.setText(NumberSupport.UI.format(this._lower));
        this._txtLower.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String v = FrequencyAnalyzerDlg.this._txtLower.getText();
                if (NumberSupport.UI.isValidNumber(v)) {
                    FrequencyAnalyzerDlg.this._lower = NumberSupport.UI.asDoubleNE(v);
                    FrequencyAnalyzerDlg.this._btnOK.setEnabled(true);
                    FrequencyAnalyzerDlg.this._txtLower.setForeground(FrequencyAnalyzerDlg.this._shell.getDisplay().getSystemColor(21));
                } else {
                    FrequencyAnalyzerDlg.this._btnOK.setEnabled(false);
                    FrequencyAnalyzerDlg.this._txtLower.setForeground(SWTResourceManager.getColor(255, 0, 0));
                }
            }
        });
        this._label_3 = new Label((Composite)this._shell, 0);
        this._label_3.setText("V");
        this._label_1 = new Label((Composite)this._shell, 0);
        this._label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label_1.setText("Upper voltage:");
        this._txtUpper = new Text((Composite)this._shell, 2048);
        this._txtUpper.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._txtUpper.setText(NumberSupport.UI.format(this._upper));
        this._txtUpper.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String v = FrequencyAnalyzerDlg.this._txtUpper.getText();
                if (NumberSupport.UI.isValidNumber(v)) {
                    FrequencyAnalyzerDlg.this._upper = NumberSupport.UI.asDoubleNE(v);
                    FrequencyAnalyzerDlg.this._btnOK.setEnabled(true);
                    FrequencyAnalyzerDlg.this._txtUpper.setForeground(FrequencyAnalyzerDlg.this._shell.getDisplay().getSystemColor(21));
                } else {
                    FrequencyAnalyzerDlg.this._btnOK.setEnabled(false);
                    FrequencyAnalyzerDlg.this._txtUpper.setForeground(SWTResourceManager.getColor(255, 0, 0));
                }
            }
        });
        this._label_4 = new Label((Composite)this._shell, 0);
        this._label_4.setText("V");
        this._label_2 = new Label((Composite)this._shell, 0);
        this._label_2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label_2.setText("Lookup buffer size:");
        this._spnLookupSize = new Spinner((Composite)this._shell, 2048);
        this._spnLookupSize.setMaximum(65536);
        this._spnLookupSize.setMinimum(512);
        this._spnLookupSize.setSelection(this._lookupSize);
        this._spnLookupSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FrequencyAnalyzerDlg.this._lookupSize = FrequencyAnalyzerDlg.this._spnLookupSize.getSelection();
            }
        });
        this._spnLookupSize.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)this._shell, 0);
        this._composite = new Composite((Composite)this._shell, 0);
        this._composite.setLayoutData((Object)new GridData(131072, 4, false, false, 3, 1));
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        this._composite.setLayout((Layout)gl_composite);
        this._btnOK = new Button(this._composite, 0);
        GridData gd_btnOK = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnOK.widthHint = 120;
        this._btnOK.setLayoutData((Object)gd_btnOK);
        this._btnOK.setImage(SWTResourceManager.getImage(PT1000Dlg.class, "/com/cesys/apps/cebomultilogger/resources/OK.png"));
        this._btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrequencyAnalyzerDlg.this._result = true;
                FrequencyAnalyzerDlg.this._shell.close();
            }
        });
        this._btnOK.setText("OK");
        this._btnCancel = new Button(this._composite, 0);
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = 120;
        this._btnCancel.setLayoutData((Object)gd_btnCancel);
        this._btnCancel.setImage(SWTResourceManager.getImage(PT1000Dlg.class, "/com/cesys/apps/cebomultilogger/resources/Cancel.png"));
        this._btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrequencyAnalyzerDlg.this._shell.close();
            }
        });
        this._btnCancel.setText("Cancel");
    }
}

