/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.processing;

import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IProcessing;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.apps.cebomultilogger.plugins.ProcessingCategories;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import com.cesys.apps.cebomultilogger.processing.FrequencyAnalyzerDlg;
import com.hobb1t.xml2.XElement;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class FrequencyAnalyzer
implements IProcessing {
    private double _lower = -0.1;
    private double _upper = 0.1;
    private int _lookupSize = 512;
    private int _count = 0;
    private boolean _hi = false;
    private final ArrayDeque<Boolean> _states = new ArrayDeque();

    private void addValue(double amplitude) {
        while (this._states.size() > this._lookupSize - 1) {
            boolean dropped = this._states.poll();
            if (!dropped) continue;
            --this._count;
        }
        boolean hf = false;
        if (this._hi) {
            if (amplitude < this._lower) {
                this._hi = false;
            }
        } else if (amplitude > this._upper) {
            this._hi = true;
            hf = true;
        }
        this._states.add(hf);
        if (hf) {
            ++this._count;
        }
    }

    @Override
    public String getTypeName() {
        return "FreqAna";
    }

    @Override
    public String getName() {
        return "Frequency Analyzer";
    }

    @Override
    public String getParamInfo() {
        return String.format("l/u: %s/%s, lus: %s", NumberSupport.UI.format(this._lower), NumberSupport.UI.format(this._upper), NumberSupport.UI.format(this._lookupSize));
    }

    @Override
    public ProcessingCategories getCategory() {
        return ProcessingCategories.ANALOG_CONVERSION;
    }

    @Override
    public IProcessing createInstance() {
        return new FrequencyAnalyzer();
    }

    @Override
    public Sample transformValue(Sample value, long timeStamp, IDevice device, boolean live) {
        if (live) {
            return new Sample("N/A");
        }
        if (device.getFrequency() <= 0.0) {
            return new Sample(Double.NaN, "");
        }
        this.addValue(value.getNumber().doubleValue());
        if (this._states.isEmpty()) {
            return new Sample(0, "Hz");
        }
        double ratio = device.getFrequency() / (double)this._states.size();
        double frequency = (double)this._count * ratio;
        return new Sample(frequency, "Hz");
    }

    @Override
    public boolean hasConfiguration() {
        return true;
    }

    @Override
    public boolean configure(Shell parent) {
        FrequencyAnalyzerDlg dlg = new FrequencyAnalyzerDlg(parent, this._lower, this._upper, this._lookupSize);
        if (dlg.open()) {
            this._lower = dlg.getLower();
            this._upper = dlg.getUpper();
            this._lookupSize = dlg.getLookupSize();
            return true;
        }
        return false;
    }

    @Override
    public List<XElement> getConfig() {
        XElement x = new XElement("config");
        x.setAttribute("lower", this._lower);
        x.setAttribute("upper", this._upper);
        x.setAttribute("lookupsize", this._lookupSize);
        return Arrays.asList(x);
    }

    @Override
    public void setConfig(List<XElement> config) {
        for (XElement x : config) {
            this._lower = x.getAttribute("lower", 0.0);
            this._upper = x.getAttribute("upper", 0.0);
            this._lookupSize = x.getAttribute("lookupsize", 512);
        }
    }
}

