/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.plugins;

import com.cesys.apps.cebomultilogger.plugins.NumberSupport;

public class Sample {
    private final Type _type;
    private final Number _number;
    private final String _string;

    public Type getType() {
        return this._type;
    }

    public String getString() {
        return this._string;
    }

    public Number getNumber() {
        return this._number;
    }

    public String getUnit() {
        return this._string;
    }

    public Sample(String string) {
        this._type = Type.STRING;
        this._number = 0;
        this._string = string;
    }

    public Sample(Type type, String unit) {
        this._type = type;
        this._number = 0;
        this._string = unit;
    }

    public Sample(byte value, String unit) {
        this._type = Type.BYTE;
        this._number = new Byte(value);
        this._string = unit;
    }

    public Sample(short value, String unit) {
        this._type = Type.SHORT;
        this._number = new Short(value);
        this._string = unit;
    }

    public Sample(int value, String unit) {
        this._type = Type.INT;
        this._number = new Integer(value);
        this._string = unit;
    }

    public Sample(long value, String unit) {
        this._type = Type.LONG;
        this._number = new Long(value);
        this._string = unit;
    }

    public Sample(float value, String unit) {
        this._type = Type.FLOAT;
        this._number = new Float(value);
        this._string = unit;
    }

    public Sample(double value, String unit) {
        this._type = Type.DOUBLE;
        this._number = new Double(value);
        this._string = unit;
    }

    public String toString() {
        return NumberSupport.EXPORT.toUnitString(this._number.floatValue(), this._string) + " / " + this._type.toString();
    }

    public static enum Type {
        STRING(0),
        BYTE(1),
        SHORT(2),
        INT(4),
        LONG(8),
        FLOAT(4),
        DOUBLE(8);

        private final int _byteSize;

        public int getByteSize() {
            return this._byteSize;
        }

        private Type(int byteSize) {
            this._byteSize = byteSize;
        }
    }
}

