/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.plugins;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.joda.time.DateTime;

public enum NumberSupport {
    UI,
    EXPORT;

    private NumberFormat _nf = NumberFormat.getInstance();
    private String _unitSeparator = " ";

    public synchronized String getUnitSeparator() {
        return this._unitSeparator;
    }

    public synchronized void setLocaleId(int localeId, boolean grouping) {
        switch (localeId) {
            case 0: {
                this._nf = NumberFormat.getInstance(Locale.ROOT);
                break;
            }
            case 1: {
                this._nf = NumberFormat.getInstance();
            }
        }
        this._nf.setGroupingUsed(grouping);
    }

    public synchronized boolean isValidNumber(String txt) {
        try {
            this._nf.parse(txt);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public synchronized String format(float value) {
        return this.format(value, 3);
    }

    public synchronized String format(float value, int digits) {
        this._nf.setMinimumFractionDigits(digits);
        this._nf.setMaximumFractionDigits(digits);
        return this._nf.format(value);
    }

    public synchronized float asFloat(String txt) throws ParseException {
        return this._nf.parse(txt).floatValue();
    }

    public synchronized float asFloatNE(String txt) {
        try {
            return this.asFloat(txt);
        }
        catch (ParseException parseException) {
            return 0.0f;
        }
    }

    public synchronized String format(double value) {
        return this.format(value, 3);
    }

    public synchronized String format(double value, int digits) {
        this._nf.setMinimumFractionDigits(digits);
        this._nf.setMaximumFractionDigits(digits);
        return this._nf.format(value);
    }

    public synchronized double asDouble(String txt) throws ParseException {
        return this._nf.parse(txt).doubleValue();
    }

    public synchronized double asDoubleNE(String txt) {
        try {
            return this.asDouble(txt);
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    public synchronized String format(int value) {
        this._nf.setMinimumFractionDigits(0);
        this._nf.setMaximumFractionDigits(0);
        return this._nf.format(value);
    }

    public synchronized String format(long value) {
        this._nf.setMinimumFractionDigits(0);
        this._nf.setMaximumFractionDigits(0);
        return this._nf.format(value);
    }

    public synchronized String toDurationString(long ms) {
        long d = ms / 1000L;
        long seconds = d % 60L;
        long minutes = (d /= 60L) % 60L;
        long hours = (d /= 60L) % 24L;
        long days = d /= 24L;
        return String.format("%dd, %dh, %dm, %ds", days, hours, minutes, seconds);
    }

    public synchronized String toUnitString(double value, String unit) {
        return this.format(value) + this._unitSeparator + unit;
    }

    public synchronized String toUnitString(double value, int digits, String unit) {
        return this.format(value, digits) + this._unitSeparator + unit;
    }

    public synchronized String toPrefixString(double value, String unit, double step) {
        String prefix = "";
        if (value == 0.0) {
            return "0" + this._unitSeparator + unit;
        }
        if (value < 1.0) {
            if (value < 1.0) {
                value *= step;
                prefix = "m";
            }
            if (value < 1.0) {
                value *= step;
                prefix = "\u00b5";
            }
            if (value < 1.0) {
                value *= step;
                prefix = "n";
            }
        } else {
            if (value >= step) {
                value /= step;
                prefix = "k";
            }
            if (value >= step) {
                value /= step;
                prefix = "M";
            }
            if (value >= step) {
                value /= step;
                prefix = "G";
            }
            if (value >= step) {
                value /= step;
                prefix = "T";
            }
        }
        return this.format(value) + this._unitSeparator + prefix + unit;
    }

    public synchronized String toPrefixString(double value, String unit) {
        return this.toPrefixString(value, unit, 1000.0);
    }

    public synchronized String toPrefixStringB(double value, String unit) {
        return this.toPrefixString(value, unit, 1024.0);
    }

    public synchronized String convertSystemMillisToDateString(long sm) {
        DateTime dt = new DateTime(sm);
        return dt.toLocalDateTime().toString("yyyy-MM-dd.hh-mm-ss-SSS");
    }
}

