/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.plugins;

import com.cesys.apps.cebomultilogger.plugins.IFormatting;
import com.cesys.apps.cebomultilogger.plugins.IObserver;
import com.cesys.apps.cebomultilogger.plugins.IProcessing;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import com.cesys.apps.cebomultilogger.processing.PassThrough;
import java.util.ArrayList;

public abstract class AbstractSource
implements ISource {
    private IProcessing _processing = new PassThrough();
    private IFormatting _formatting;
    private String _name = "unnamed";
    private final ArrayList<IObserver> _observers = new ArrayList();

    protected AbstractSource(IFormatting defaultFormatting) {
        this._formatting = defaultFormatting;
    }

    protected void setModified(String reason) {
        for (IObserver o : this._observers) {
            o.modified(reason);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        if (this._name.equals(name)) {
            return;
        }
        this._name = name;
        this.setModified("Name changed");
    }

    @Override
    public IProcessing getProcessing() {
        return this._processing;
    }

    @Override
    public void setProcessing(IProcessing processing) {
        this._processing = processing;
        this.setModified("Processing changed");
    }

    @Override
    public IFormatting getFormatting() {
        return this._formatting;
    }

    @Override
    public void setFormatting(IFormatting formatting) {
        this._formatting = formatting;
        this.setModified("Formatting modified");
    }

    @Override
    public void addModificationObserver(IObserver observer) {
        this._observers.add(observer);
    }
}

