/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.plugins;

import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IObserver;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import java.util.ArrayList;

public abstract class AbstractDevice
implements IDevice {
    protected String _name = "unnamed";
    protected String _serial = "*";
    private final ArrayList<IObserver> _observers = new ArrayList();

    protected void setModified(String reason) {
        for (IObserver o : this._observers) {
            o.modified(reason);
        }
    }

    protected AbstractDevice(String serial) {
        this._serial = serial;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        if (this._name.equals(name)) {
            return;
        }
        this._name = name;
        this.setModified("Name changed");
    }

    @Override
    public String getSerialNumber() {
        return this._serial;
    }

    @Override
    public void setSerialNumber(String serialNumber) {
        if (this._serial.equals(serialNumber)) {
            return;
        }
        this._serial = serialNumber;
        this.setModified("Serial changed");
    }

    @Override
    public void addModificationObserver(IObserver observer) {
        this._observers.add(observer);
    }

    @Override
    public ISource createSourceByType(String type) {
        for (ISource iSource : this.getAnalogSources()) {
            if (iSource == null || !iSource.getTypeName().equals(type)) continue;
            return iSource;
        }
        for (ISource iSource : this.getDigitalSources()) {
            if (iSource == null || !iSource.getTypeName().equals(type)) continue;
            return iSource;
        }
        return null;
    }
}

