/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.formatting;

import com.cesys.apps.cebomultilogger.plugins.FormattingCategories;
import com.cesys.apps.cebomultilogger.plugins.IFormatting;
import com.cesys.apps.cebomultilogger.plugins.Sample;

public class DecHexFormat
implements IFormatting {
    private static final String[] _format = new String[]{"", "%d / 0x%02x", "%d / 0x%04x", "", "%d / 0x%08x", "", "", "", "%d / 0x%016x"};

    @Override
    public String getTypeName() {
        return "DecHex";
    }

    @Override
    public String getName() {
        return "Decimal and hexadecimal display";
    }

    @Override
    public FormattingCategories getCategory() {
        return FormattingCategories.DIGITAL;
    }

    @Override
    public String format(Sample value) {
        return String.format(_format[value.getType().getByteSize()], value.getNumber().longValue(), value.getNumber().longValue());
    }
}

