/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.formatting;

import com.cesys.apps.cebomultilogger.plugins.FormattingCategories;
import com.cesys.apps.cebomultilogger.plugins.IFormatting;
import com.cesys.apps.cebomultilogger.plugins.Sample;

public class DecBinFormat
implements IFormatting {
    @Override
    public String getTypeName() {
        return "DecBin";
    }

    @Override
    public String getName() {
        return "Decimal and binary display";
    }

    @Override
    public FormattingCategories getCategory() {
        return FormattingCategories.DIGITAL;
    }

    @Override
    public String format(Sample value) {
        int digits = value.getType().getByteSize() * 8;
        long m = 1 << digits;
        long v = value.getNumber().longValue();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < digits) {
            sb.append((v & m) != 0L ? "1" : "0");
            if ((i & 3) == 3) {
                sb.append(" ");
            }
            ++i;
            m >>= 1;
        }
        return String.format("%d / %s", value.getNumber().longValue(), sb.toString());
    }
}

