/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.formatting;

import com.cesys.apps.cebomultilogger.plugins.FormattingCategories;
import com.cesys.apps.cebomultilogger.plugins.IFormatting;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import java.util.Locale;

public class BaseAnalogFormat
implements IFormatting {
    private final String _desc;
    private final String _typeName;
    private final int _digits;

    protected BaseAnalogFormat(String desc, Locale locale, int digits, String typeName) {
        this._desc = desc;
        this._typeName = typeName;
        this._digits = digits;
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public String getName() {
        return this._desc;
    }

    @Override
    public FormattingCategories getCategory() {
        return FormattingCategories.ANALOG;
    }

    @Override
    public String format(Sample value) {
        return NumberSupport.UI.toUnitString(value.getNumber().doubleValue(), this._digits, value.getUnit());
    }

    public static class HighPrecisionAnalogFormat
    extends BaseAnalogFormat {
        public HighPrecisionAnalogFormat() {
            super("High precision", null, 6, "HighPrecisionAnalogFormat");
        }
    }

    public static class MediumPrecisionAnalogFormat
    extends BaseAnalogFormat {
        public MediumPrecisionAnalogFormat() {
            super("Medium precision", null, 3, "MediumPrecisionAnalogFormat");
        }
    }
}

