/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.export;

import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrDlg;
import com.cesys.apps.cebomultilogger.export.CsvExportConfig;
import com.cesys.apps.cebomultilogger.utils.Utils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CsvExportDlg
extends Dialog {
    private final CsvExportConfig _in;
    protected CsvExportConfig _result = null;
    protected Shell _shell;
    private Composite _composite;
    private Button _btnOK;
    private Button _btnCancel;
    private Label _label;
    private Label _label_1;
    private Button _btnColumnHeader;
    private Button _btnProjectConfiguration;
    private Label _label_2;
    private Text _txtOutputDir;
    private Text _txtSeparator;
    private Combo _cmbLocale;
    private Button _btnOutputTimeStamp;
    private Button _btnChoosePath;
    private Button _btnOutputNumbers;
    private Button _btnNumberGrouping;
    private Combo _cmbTsUnit;
    private Label _lblInfo;
    private Composite _composite_1;

    public CsvExportDlg(Shell parent, CsvExportConfig in) {
        super(parent, Utils.getDialogStyle());
        this._in = in;
    }

    private void init() {
        this._txtOutputDir.setText(this._in.getOutputDir());
        this._txtSeparator.setText(this._in.getSeparator());
        this._cmbLocale.select(this._in.getNumberSupportId());
        this._btnNumberGrouping.setSelection(this._in.isNumberGrouping());
        this._btnProjectConfiguration.setSelection(this._in.isOutputInfo());
        this._btnColumnHeader.setSelection(this._in.isOutputHeaders());
        this._btnOutputNumbers.setSelection(this._in.isOutputNumbers());
        this._btnOutputTimeStamp.setSelection(this._in.isOutputTimeStamp());
        this._cmbTsUnit.select(this._in.getTimeStampUnit());
        this._txtOutputDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CsvExportDlg.this.validate();
            }
        });
        this._txtSeparator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CsvExportDlg.this.validate();
            }
        });
        this._btnChoosePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String r = Utils.showFolderSelectionDialog(CsvExportDlg.this._shell, "Select folder for output");
                if (r != null) {
                    CsvExportDlg.this._txtOutputDir.setText(r);
                }
            }
        });
        this.validate();
        this._shell.pack();
        Utils.centerOnParent(this._shell, this.getParent());
    }

    private void validate() {
        String bad = "";
        if (this._txtOutputDir.getText().isEmpty()) {
            bad = "No output defined.";
        }
        if (this._txtSeparator.getText().isEmpty()) {
            bad = "No separator defined.";
        }
        this._lblInfo.setText(bad);
        this._btnOK.setEnabled(bad.isEmpty());
    }

    public CsvExportConfig open() {
        this.createContents();
        this.init();
        this._shell.open();
        this._shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this._result;
    }

    private void createContents() {
        this._shell = new Shell(this.getParent(), this.getStyle());
        this._shell.setImage(SWTResourceManager.getImage(CsvExportDlg.class, "/com/cesys/apps/cebomultilogger/resources/Download.png"));
        this._shell.setSize(450, 293);
        this._shell.setText("CSV Export configuration");
        GridLayout gl_shell = new GridLayout();
        gl_shell.numColumns = 3;
        this._shell.setLayout((Layout)gl_shell);
        this._label_2 = new Label((Composite)this._shell, 0);
        this._label_2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label_2.setText("Ouput directory:");
        this._composite_1 = new Composite((Composite)this._shell, 0);
        this._composite_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gl_composite_1 = new GridLayout(2, false);
        gl_composite_1.marginWidth = 0;
        gl_composite_1.marginHeight = 0;
        this._composite_1.setLayout((Layout)gl_composite_1);
        this._txtOutputDir = new Text(this._composite_1, 2048);
        GridData gd_txtOutputDir = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtOutputDir.widthHint = 300;
        this._txtOutputDir.setLayoutData((Object)gd_txtOutputDir);
        this._btnChoosePath = new Button(this._composite_1, 0);
        this._btnChoosePath.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._btnChoosePath.setImage(SWTResourceManager.getImage(CsvExportDlg.class, "/com/cesys/apps/cebomultilogger/resources/Save.png"));
        this._label = new Label((Composite)this._shell, 0);
        this._label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label.setText("Sample separator:");
        this._txtSeparator = new Text((Composite)this._shell, 2048);
        this._txtSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._label_1 = new Label((Composite)this._shell, 0);
        this._label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label_1.setText("Formatting locale:");
        this._cmbLocale = new Combo((Composite)this._shell, 8);
        this._cmbLocale.setItems(new String[]{"Neutral locale", "Current system locale"});
        this._cmbLocale.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._cmbLocale.select(0);
        new Label((Composite)this._shell, 0);
        this._btnNumberGrouping = new Button((Composite)this._shell, 32);
        this._btnNumberGrouping.setText("Group numbers");
        new Label((Composite)this._shell, 0);
        new Label((Composite)this._shell, 0);
        this._btnProjectConfiguration = new Button((Composite)this._shell, 32);
        this._btnProjectConfiguration.setText("Project information");
        new Label((Composite)this._shell, 0);
        new Label((Composite)this._shell, 0);
        this._btnColumnHeader = new Button((Composite)this._shell, 32);
        this._btnColumnHeader.setText("Column header");
        new Label((Composite)this._shell, 0);
        new Label((Composite)this._shell, 0);
        this._btnOutputNumbers = new Button((Composite)this._shell, 32);
        this._btnOutputNumbers.setText("Sample numbers");
        new Label((Composite)this._shell, 0);
        new Label((Composite)this._shell, 0);
        this._btnOutputTimeStamp = new Button((Composite)this._shell, 32);
        this._btnOutputTimeStamp.setText("Time stamp");
        this._cmbTsUnit = new Combo((Composite)this._shell, 8);
        this._cmbTsUnit.setItems(new String[]{"ns", "\u00b5s", "ms"});
        this._cmbTsUnit.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this._cmbTsUnit.select(0);
        this._lblInfo = new Label((Composite)this._shell, 0);
        this._lblInfo.setForeground(SWTResourceManager.getColor(3));
        this._lblInfo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this._lblInfo.setText("-");
        this._composite = new Composite((Composite)this._shell, 0);
        this._composite.setLayoutData((Object)new GridData(131072, 4, false, false, 3, 1));
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        this._composite.setLayout((Layout)gl_composite);
        this._btnOK = new Button(this._composite, 0);
        this._btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvExportDlg.this._result = new CsvExportConfig(CsvExportDlg.this._txtOutputDir.getText(), CsvExportDlg.this._txtSeparator.getText(), CsvExportDlg.this._cmbLocale.getSelectionIndex(), CsvExportDlg.this._cmbTsUnit.getSelectionIndex(), CsvExportDlg.this._btnNumberGrouping.getSelection(), CsvExportDlg.this._btnOutputNumbers.getSelection(), CsvExportDlg.this._btnOutputTimeStamp.getSelection(), CsvExportDlg.this._btnColumnHeader.getSelection(), CsvExportDlg.this._btnProjectConfiguration.getSelection());
                CsvExportDlg.this._shell.close();
            }
        });
        GridData gd_btnOK = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnOK.widthHint = 120;
        this._btnOK.setLayoutData((Object)gd_btnOK);
        this._btnOK.setImage(SWTResourceManager.getImage(CeboMsrDlg.class, "/com/cesys/apps/cebomultilogger/resources/OK.png"));
        this._btnOK.setText("OK");
        this._btnCancel = new Button(this._composite, 0);
        this._btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvExportDlg.this._shell.close();
            }
        });
        GridData gd_btnCancel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = 120;
        this._btnCancel.setLayoutData((Object)gd_btnCancel);
        this._btnCancel.setImage(SWTResourceManager.getImage(CeboMsrDlg.class, "/com/cesys/apps/cebomultilogger/resources/Cancel.png"));
        this._btnCancel.setText("Cancel");
    }
}

