/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.export;

import com.hobb1t.xml2.XElement;
import java.util.Arrays;
import java.util.List;

public class CsvExportConfig {
    private final String _outputDir;
    private final String _separator;
    private final int _numberSupportId;
    private final int _timeStampUnit;
    private final boolean _numberGrouping;
    private final boolean _outputNumbers;
    private final boolean _outputTimeStamp;
    private final boolean _outputHeaders;
    private final boolean _outputInfo;

    public String getOutputDir() {
        return this._outputDir;
    }

    public String getSeparator() {
        return this._separator;
    }

    public int getNumberSupportId() {
        return this._numberSupportId;
    }

    public int getTimeStampUnit() {
        return this._timeStampUnit;
    }

    public boolean isNumberGrouping() {
        return this._numberGrouping;
    }

    public boolean isOutputNumbers() {
        return this._outputNumbers;
    }

    public boolean isOutputTimeStamp() {
        return this._outputTimeStamp;
    }

    public boolean isOutputHeaders() {
        return this._outputHeaders;
    }

    public boolean isOutputInfo() {
        return this._outputInfo;
    }

    public CsvExportConfig() {
        this("", ";", 0, 1, false, false, true, true, true);
    }

    public CsvExportConfig(String outputDir, String separator, int numberSupportId, int timeStampUnit, boolean numberGrouping, boolean outputNumbers, boolean outputTimeStamp, boolean outputHeaders, boolean outputInfo) {
        this._outputDir = outputDir;
        this._separator = separator;
        this._numberSupportId = numberSupportId;
        this._timeStampUnit = timeStampUnit;
        this._numberGrouping = numberGrouping;
        this._outputNumbers = outputNumbers;
        this._outputTimeStamp = outputTimeStamp;
        this._outputHeaders = outputHeaders;
        this._outputInfo = outputInfo;
    }

    public List<XElement> asXml() {
        XElement r = new XElement("config");
        r.setAttribute("outputdir", this._outputDir);
        r.setAttribute("separator", this._separator);
        r.setAttribute("numbersupportid", this._numberSupportId);
        r.setAttribute("timestampunit", this._timeStampUnit);
        r.setAttribute("numbergrouping", this._numberGrouping);
        r.setAttribute("outputnumbers", this._outputNumbers);
        r.setAttribute("outputtimestamp", this._outputTimeStamp);
        r.setAttribute("outputheaders", this._outputHeaders);
        r.setAttribute("outputinfo", this._outputInfo);
        return Arrays.asList(r);
    }

    public boolean isValid() {
        return !this._outputDir.isEmpty() && !this._separator.isEmpty();
    }

    public static CsvExportConfig fromXml(List<XElement> config) {
        XElement e;
        CsvExportConfig defaults = new CsvExportConfig();
        if (!config.isEmpty() && (e = config.get(0)).getName().equals("config")) {
            return new CsvExportConfig(e.getAttribute("outputdir", defaults._outputDir), e.getAttribute("separator", defaults._separator), e.getAttribute("numbersupportid", defaults._numberSupportId), e.getAttribute("timestampunit", defaults._timeStampUnit), e.getAttribute("numbergrouping", defaults._numberGrouping), e.getAttribute("outputnumbers", defaults._outputNumbers), e.getAttribute("outputtimestamp", defaults._outputTimeStamp), e.getAttribute("outputheaders", defaults._outputHeaders), e.getAttribute("outputinfo", defaults._outputInfo));
        }
        return defaults;
    }
}

