/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.export;

import com.cesys.apps.cebomultilogger.DeviceDataReader;
import com.cesys.apps.cebomultilogger.export.CsvExportConfig;
import com.cesys.apps.cebomultilogger.export.CsvExportDlg;
import com.cesys.apps.cebomultilogger.plugins.IDataReader;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IExportControl;
import com.cesys.apps.cebomultilogger.plugins.IExportPlugin;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import com.hobb1t.xml2.XElement;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.widgets.Shell;

public class CsvExport
implements IExportPlugin {
    private CsvExportConfig _cfg = new CsvExportConfig();

    @Override
    public String getTypeName() {
        return "CSV";
    }

    @Override
    public IExportPlugin createInstance() {
        return new CsvExport();
    }

    @Override
    public boolean hasConfiguration() {
        return true;
    }

    @Override
    public boolean isConfigurationValid() {
        return this._cfg.isValid();
    }

    @Override
    public boolean configure(Shell parent) {
        CsvExportConfig cfg = new CsvExportDlg(parent, this._cfg).open();
        if (cfg != null) {
            this._cfg = cfg;
            return true;
        }
        return false;
    }

    @Override
    public void export(IExportControl control, IDataReader reader, String name) throws IOException {
        for (int i = 0; i < reader.getDevices().size(); ++i) {
            this.exportDevice(control, reader, name, i, reader.getDevices().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDevice(IExportControl control, IDataReader reader, String name, int device, int deviceCount) throws IOException {
        control.setTask(String.format("Export data for device %d / %d", device + 1, deviceCount));
        String fileName = FilenameUtils.concat((String)this._cfg.getOutputDir(), (String)(name + "_" + device + ".csv"));
        FileWriter fw = new FileWriter(fileName);
        BufferedWriter bw = new BufferedWriter(fw);
        NumberSupport ns = NumberSupport.EXPORT;
        ns.setLocaleId(this._cfg.getNumberSupportId(), this._cfg.isNumberGrouping());
        DeviceDataReader dr = reader.getReaderOf(device);
        String tsu = "";
        long tsd = 0L;
        switch (this._cfg.getTimeStampUnit()) {
            case 0: {
                tsu = "ns";
                tsd = 1L;
                break;
            }
            case 1: {
                tsu = "us";
                tsd = 1000L;
                break;
            }
            case 2: {
                tsu = "ms";
                tsd = 1000000L;
            }
        }
        try {
            if (this._cfg.isOutputInfo()) {
                IDevice d = reader.getDevices().get(device);
                bw.write("Comment: " + reader.getProjectComment() + "\n");
                bw.write("Started: " + ns.convertSystemMillisToDateString(reader.getStartTimeMs()) + "\n");
                bw.write("Duration: " + ns.toDurationString(reader.getDurationMs()) + "\n");
                bw.write(String.format("Device %s / %s, %s\n", d.getName(), d.getSerialNumber(), d.getFrequency() <= 0.0 ? "External triggered" : ns.toUnitString(d.getFrequency(), "Hz")));
            }
            List<ISource> ss = reader.getSources();
            if (this._cfg.isOutputHeaders()) {
                List<Sample> values;
                if (this._cfg.isOutputNumbers()) {
                    bw.write("Number");
                    bw.write(this._cfg.getSeparator());
                }
                if (this._cfg.isOutputTimeStamp()) {
                    bw.write("TimeStamp");
                    bw.write(this._cfg.getSeparator());
                }
                for (int i = 0; i < ss.size(); ++i) {
                    ISource s = ss.get(i);
                    bw.write(s.getName());
                    if (i < ss.size() - 1) {
                        bw.write(this._cfg.getSeparator());
                        continue;
                    }
                    bw.write("\n");
                }
                if (this._cfg.isOutputNumbers()) {
                    bw.write("#");
                    bw.write(this._cfg.getSeparator());
                }
                if (this._cfg.isOutputTimeStamp()) {
                    bw.write(tsu);
                    bw.write(this._cfg.getSeparator());
                }
                if ((values = dr.getCurrentValues()) != null) {
                    for (int i = 0; i < values.size(); ++i) {
                        Sample s = values.get(i);
                        bw.write(s.getUnit());
                        if (i < values.size() - 1) {
                            bw.write(this._cfg.getSeparator());
                            continue;
                        }
                        bw.write("\n");
                    }
                }
            }
            long number = 1L;
            while (!dr.isEOS() && !control.isTerminationRequested()) {
                if (number % 1000L == 0L) {
                    double progress = (double)dr.getCurrentTimeStamp() / (double)reader.getDurationMs() / 1000000.0;
                    control.setProgress(progress);
                }
                if (this._cfg.isOutputNumbers()) {
                    bw.write(ns.format(number));
                    bw.write(this._cfg.getSeparator());
                }
                if (this._cfg.isOutputTimeStamp()) {
                    bw.write(ns.format(dr.getCurrentTimeStamp() / tsd));
                    bw.write(this._cfg.getSeparator());
                }
                List<Sample> values = dr.getCurrentValues();
                for (int i = 0; i < values.size(); ++i) {
                    Sample v = values.get(i);
                    String val = "";
                    switch (v.getType()) {
                        case STRING: {
                            val = v.getString();
                            break;
                        }
                        case BYTE: 
                        case SHORT: 
                        case INT: 
                        case LONG: {
                            val = ns.format(v.getNumber().longValue());
                            break;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            val = ns.format(v.getNumber().doubleValue(), 6);
                        }
                    }
                    bw.write(val);
                    if (i < values.size() - 1) {
                        bw.write(this._cfg.getSeparator());
                        continue;
                    }
                    bw.write("\n");
                }
                ++number;
                dr.next();
            }
        }
        finally {
            bw.close();
        }
    }

    @Override
    public List<XElement> getConfig() {
        return this._cfg.asXml();
    }

    @Override
    public void setConfig(List<XElement> config) {
        this._cfg = CsvExportConfig.fromXml(config);
    }
}

