/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.cebomsr;

import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrConfig;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.apps.cebomultilogger.utils.Utils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CeboMsrDlg
extends Dialog {
    private final CeboMsrConfig _initConfig;
    private int _prevCaptureMode = -1;
    protected Object _result = null;
    protected Shell _shell;
    private Label _label;
    private Combo _cmbCaptureMode;
    private Label _label_1;
    private Label _label_2;
    private Button _btnTriggerOutput;
    private Label _label_3;
    private Combo _cmbTriggerModes;
    private Composite _composite;
    private Button _btnOK;
    private Button _btnCancel;
    private Text _txtFrequency;

    private void updateControls() {
        if (this._cmbCaptureMode.getSelectionIndex() == 0) {
            this._btnTriggerOutput.setEnabled(true);
            this._txtFrequency.setEnabled(true);
            if (this._prevCaptureMode != 0) {
                this._cmbTriggerModes.removeAll();
                this._cmbTriggerModes.add("Pulse");
                this._cmbTriggerModes.add("Alternating");
                this._cmbTriggerModes.select(0);
            }
        } else {
            this._btnTriggerOutput.setEnabled(false);
            this._txtFrequency.setEnabled(false);
            if (this._prevCaptureMode != 1) {
                this._cmbTriggerModes.removeAll();
                this._cmbTriggerModes.add("Rising Edge");
                this._cmbTriggerModes.add("Falling Edge");
                this._cmbTriggerModes.add("Alternating");
                this._cmbTriggerModes.select(0);
            }
        }
        this._prevCaptureMode = this._cmbCaptureMode.getSelectionIndex();
    }

    private void init() {
        this._cmbCaptureMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CeboMsrDlg.this.updateControls();
            }
        });
        this._cmbCaptureMode.select(this._initConfig.getCaptureMode());
        this.updateControls();
        this._txtFrequency.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NumberSupport.UI.isValidNumber(CeboMsrDlg.this._txtFrequency.getText())) {
                    CeboMsrDlg.this._btnOK.setEnabled(true);
                    CeboMsrDlg.this._txtFrequency.setForeground(CeboMsrDlg.this._shell.getDisplay().getSystemColor(21));
                } else {
                    CeboMsrDlg.this._btnOK.setEnabled(false);
                    CeboMsrDlg.this._txtFrequency.setForeground(SWTResourceManager.getColor(255, 0, 0));
                }
            }
        });
        this._txtFrequency.setText(NumberSupport.UI.format(this._initConfig.getFrequency()));
        this._btnTriggerOutput.setSelection(this._initConfig.isOutputTrigger());
        this._cmbTriggerModes.select(this._initConfig.getTriggerMode());
        this._shell.pack();
        Utils.centerOnParent(this._shell, this.getParent());
    }

    public CeboMsrDlg(Shell parent, CeboMsrConfig config) {
        super(parent, Utils.getDialogStyle());
        this._initConfig = config;
    }

    public Object open() {
        this.createContents();
        this.init();
        this._shell.open();
        this._shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this._result;
    }

    private void createContents() {
        this._shell = new Shell(this.getParent(), this.getStyle());
        this._shell.setImage(SWTResourceManager.getImage(CeboMsrDlg.class, "/com/cesys/apps/cebomultilogger/resources/Hard disk.png"));
        this._shell.setSize(442, 177);
        this._shell.setText("CeboMsr configuration");
        GridLayout gl_shell = new GridLayout();
        gl_shell.numColumns = 3;
        this._shell.setLayout((Layout)gl_shell);
        this._label = new Label((Composite)this._shell, 0);
        this._label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label.setText("Capture mode:");
        this._cmbCaptureMode = new Combo((Composite)this._shell, 8);
        this._cmbCaptureMode.setItems(new String[]{"Constant frequency", "External triggered"});
        this._cmbCaptureMode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._cmbCaptureMode.select(0);
        this._label_1 = new Label((Composite)this._shell, 0);
        this._label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label_1.setText("Constant frequency:");
        this._txtFrequency = new Text((Composite)this._shell, 2048);
        this._txtFrequency.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this._label_2 = new Label((Composite)this._shell, 0);
        this._label_2.setText("Hz");
        this._label_3 = new Label((Composite)this._shell, 0);
        this._label_3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label_3.setText("Trigger mode:");
        this._cmbTriggerModes = new Combo((Composite)this._shell, 8);
        this._cmbTriggerModes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new Label((Composite)this._shell, 0);
        this._btnTriggerOutput = new Button((Composite)this._shell, 32);
        this._btnTriggerOutput.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this._btnTriggerOutput.setText("Output trigger");
        new Label((Composite)this._shell, 0);
        this._composite = new Composite((Composite)this._shell, 0);
        this._composite.setLayoutData((Object)new GridData(131072, 4, false, false, 2, 1));
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        this._composite.setLayout((Layout)gl_composite);
        this._btnOK = new Button(this._composite, 0);
        this._btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CeboMsrDlg.this._result = new CeboMsrConfig(CeboMsrDlg.this._cmbCaptureMode.getSelectionIndex(), CeboMsrDlg.this._cmbTriggerModes.getSelectionIndex(), NumberSupport.UI.asDoubleNE(CeboMsrDlg.this._txtFrequency.getText()), CeboMsrDlg.this._btnTriggerOutput.getSelection());
                CeboMsrDlg.this._shell.close();
            }
        });
        GridData gd_btnOK = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnOK.widthHint = 120;
        this._btnOK.setLayoutData((Object)gd_btnOK);
        this._btnOK.setImage(SWTResourceManager.getImage(CeboMsrDlg.class, "/com/cesys/apps/cebomultilogger/resources/OK.png"));
        this._btnOK.setText("OK");
        this._btnCancel = new Button(this._composite, 0);
        this._btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CeboMsrDlg.this._shell.close();
            }
        });
        GridData gd_btnCancel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = 120;
        this._btnCancel.setLayoutData((Object)gd_btnCancel);
        this._btnCancel.setImage(SWTResourceManager.getImage(CeboMsrDlg.class, "/com/cesys/apps/cebomultilogger/resources/Cancel.png"));
        this._btnCancel.setText("Cancel");
    }
}

