/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.cebomsr;

import com.cesys.apps.cebomultilogger.cebomsr.CeboLC;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrDevice;
import com.cesys.apps.cebomultilogger.cebomsr.CeboStick;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IDeviceClass;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.cebomsr.CurrentSource;
import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.DeviceType;
import com.cesys.cebomsr.LibraryInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CeboMsrDeviceClass
implements IDeviceClass {
    @Override
    public String getPluginName() {
        return "CeboMsr";
    }

    @Override
    public List<IDevice> getSupportedDevices() {
        return Arrays.asList(new CeboMsrDevice(new CeboLC(), "-", "*", ""), new CeboMsrDevice(new CeboStick(), "-", "*", ""));
    }

    @Override
    public IDevice createInstanceOf(String type, String serial) {
        switch (type) {
            case "CeboLC": {
                return new CeboMsrDevice(new CeboLC(), "-", serial, "");
            }
            case "CeboStick": {
                return new CeboMsrDevice(new CeboStick(), "-", serial, "");
            }
        }
        return null;
    }

    @Override
    public boolean isCompatibleDevice(IDevice device) {
        return device instanceof CeboMsrDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDevice> enumerateDevices() throws IOException {
        ArrayList<IDevice> r = new ArrayList<IDevice>();
        try (Device d = null;){
            List devs = LibraryInterface.enumerate((DeviceType)DeviceType.All);
            Iterator iterator = devs.iterator();
            while (iterator.hasNext()) {
                Device de;
                d = de = (Device)iterator.next();
                try {
                    d.open();
                    String serial = d.getSerialNumber();
                    String fw = d.getFirmwareVersion();
                    if (d.getDeviceType() == DeviceType.CeboLC) {
                        String info = "Current sources: ";
                        for (int i = 0; i < 2; ++i) {
                            CurrentSource cs = (CurrentSource)d.getCurrentSources().get(i);
                            info = info + cs.getName() + " = " + NumberSupport.UI.toUnitString(cs.getReferenceCurrent(), 1, "uA");
                            if (i != 0) continue;
                            info = info + "; ";
                        }
                        r.add(new CeboMsrDevice(new CeboLC(), fw, serial, info));
                        continue;
                    }
                    if (de.getDeviceType() == DeviceType.CeboStick) {
                        r.add(new CeboMsrDevice(new CeboStick(), fw, serial, ""));
                        continue;
                    }
                    throw new RuntimeException("Device not supported.");
                }
                finally {
                    d.close();
                }
            }
        }
        return r;
    }

    @Override
    public void mapInstances(List<IDevice> devices) throws IOException {
        String serial;
        List rdevs = LibraryInterface.enumerate((DeviceType)DeviceType.All);
        HashMap<String, Device> m = new HashMap<String, Device>();
        for (Device device : rdevs) {
            try {
                device.open();
                m.put(device.getSerialNumber(), device);
                device.close();
            }
            catch (IOException iOException) {}
        }
        for (IDevice iDevice : devices) {
            serial = iDevice.getSerialNumber();
            if (serial.equals("*") || !m.containsKey(serial)) continue;
            ((CeboMsrDevice)iDevice).setRealDevice((Device)m.get(serial));
            m.remove(serial);
        }
        block4: for (IDevice iDevice : devices) {
            serial = iDevice.getSerialNumber();
            if (!serial.equals("*")) continue;
            for (String k : m.keySet()) {
                Device dev = (Device)m.get(k);
                if ((dev.getDeviceType() != DeviceType.CeboLC || !iDevice.getTypeName().equals("CeboLC")) && (dev.getDeviceType() != DeviceType.CeboStick || !iDevice.getTypeName().equals("CeboStick"))) continue;
                ((CeboMsrDevice)iDevice).setRealDevice(dev);
                m.remove(k);
                continue block4;
            }
        }
    }

    @Override
    public void unmapInstances(List<IDevice> devices) throws IOException {
        for (IDevice dev : devices) {
            ((CeboMsrDevice)dev).setRealDevice(null);
        }
    }
}

