/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.cebomsr;

import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrAnalogInput;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrConfig;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrCounter;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrDigitalPort;
import com.cesys.apps.cebomultilogger.cebomsr.ICeboMsrDeviceClass;
import com.cesys.apps.cebomultilogger.plugins.AbstractDevice;
import com.cesys.apps.cebomultilogger.plugins.IAnalogSource;
import com.cesys.apps.cebomultilogger.plugins.ICaptureControl;
import com.cesys.apps.cebomultilogger.plugins.IDataWriter;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IDigitalSource;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import com.cesys.cebomsr.AnalogInput;
import com.cesys.cebomsr.Counter;
import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.DeviceType;
import com.cesys.cebomsr.DigitalPort;
import com.cesys.cebomsr.Input;
import com.cesys.cebomsr.InputFrame;
import com.cesys.cebomsr.Range;
import com.cesys.cebomsr.Trigger;
import com.hobb1t.xml2.XElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class CeboMsrDevice
extends AbstractDevice {
    private final double HOST_FREQUENCY_LIMIT = 10.0;
    private final float[] _liveSingleEnded;
    private final float[] _liveDifferential;
    private final long[] _liveCounter;
    private final byte[] _liveDigiport;
    private final String _firmware;
    private final String _info;
    private volatile boolean _daqActive = false;
    private Device _realDevice = null;
    private final ICeboMsrDeviceClass _device;
    private long _currentFrame = 0L;

    private float readAnalogInput(AnalogInput ai, int rangeId) throws IOException {
        int cRid = ai.getSupportedRanges().indexOf(ai.getRange());
        if (cRid != rangeId) {
            ai.setParameters((Range)ai.getSupportedRanges().get(rangeId));
        }
        return ai.read();
    }

    private Input getInputOfSource(ISource s) {
        if (s instanceof CeboMsrAnalogInput) {
            CeboMsrAnalogInput ai = (CeboMsrAnalogInput)s;
            if (ai.isSingleEnded()) {
                return (Input)this._realDevice.getSingleEndedInputs().get(ai.getIndex());
            }
            return (Input)this._realDevice.getDifferentialInputs().get(ai.getIndex());
        }
        if (s instanceof CeboMsrDigitalPort) {
            return (Input)this._realDevice.getDigitalPorts().get(((CeboMsrDigitalPort)s).getIndex());
        }
        if (s instanceof CeboMsrCounter) {
            return (Input)this._realDevice.getCounters().get(((CeboMsrCounter)s).getIndex());
        }
        throw new RuntimeException("Invalid input");
    }

    CeboMsrDevice(ICeboMsrDeviceClass device, String firmware, String serial, String info) {
        super(serial);
        this._liveSingleEnded = new float[device.getSingleEndedCount()];
        this._liveDifferential = new float[device.getDifferentialCount()];
        this._liveCounter = new long[device.getCounterCount()];
        this._liveDigiport = new byte[device.getDigiportCount()];
        this._firmware = firmware;
        this._info = info;
        this._device = device;
    }

    void setRealDevice(Device device) throws IOException {
        if (this._realDevice != null) {
            this._realDevice.close();
        }
        this._realDevice = device;
        if (this._realDevice != null) {
            this._realDevice.open();
        }
    }

    float readSingleEnded(int id, int rangeId) throws IOException {
        if (this._daqActive) {
            return this._liveSingleEnded[id];
        }
        if (this._realDevice != null) {
            return this.readAnalogInput((AnalogInput)this._realDevice.getSingleEndedInputs().get(id), rangeId);
        }
        return 0.0f;
    }

    float readDifferential(int id, int rangeId) throws IOException {
        if (this._daqActive) {
            return this._liveDifferential[id];
        }
        if (this._realDevice != null) {
            return this.readAnalogInput((AnalogInput)this._realDevice.getDifferentialInputs().get(id), rangeId);
        }
        return 0.0f;
    }

    long readCounter(int id) throws IOException {
        if (this._daqActive) {
            return this._liveCounter[id];
        }
        if (this._realDevice != null) {
            return ((Counter)this._realDevice.getCounters().get(id)).read();
        }
        return 0L;
    }

    int readDigitalPort(int id) throws IOException {
        if (this._daqActive) {
            return this._liveDigiport[id];
        }
        if (this._realDevice != null) {
            return ((DigitalPort)this._realDevice.getDigitalPorts().get(id)).read();
        }
        return 0;
    }

    @Override
    public String getTypeName() {
        return this._device.getTypeName();
    }

    @Override
    public String getDescription() {
        return "Interface for CeboMsr compatible devices.\nDevice firmware version: " + this._firmware + "\n" + this._info;
    }

    @Override
    public boolean isMapped() {
        return this._realDevice != null;
    }

    @Override
    public IDevice cloneInstance() {
        CeboMsrDevice d = new CeboMsrDevice(this._device.cloneInstance(), this._firmware, this.getSerialNumber(), this._info);
        d._name = this._name;
        return d;
    }

    @Override
    public boolean hasConfiguration() {
        return true;
    }

    @Override
    public boolean configure(Shell parent) {
        return this._device.configure(parent);
    }

    @Override
    public List<XElement> getConfig() {
        return this._device.getConfig().asXml();
    }

    @Override
    public void setConfig(List<XElement> config) {
        this._device.setConfig(CeboMsrConfig.fromXml(config));
    }

    @Override
    public double getFrequency() {
        if (this._device.getConfig().getCaptureMode() == 1) {
            return -1.0;
        }
        return this._device.getConfig().getFrequency();
    }

    @Override
    public List<IAnalogSource> getAnalogSources() {
        return this._device.getAnalogSources(this);
    }

    @Override
    public List<IDigitalSource> getDigitalSources() {
        return this._device.getDigitalSources(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(List<ISource> sources, ICaptureControl control, IDataWriter writer, long startTime) throws Throwable {
        if (this._realDevice != null) {
            this._currentFrame = 0L;
            CeboMsrConfig cfg = this._device.getConfig();
            boolean hostTriggered = cfg.getFrequency() < 10.0;
            try {
                long lastTS;
                int i;
                for (i = 0; i < this._device.getSingleEndedCount(); ++i) {
                    this._liveSingleEnded[i] = 0.0f;
                }
                for (i = 0; i < this._device.getDifferentialCount(); ++i) {
                    this._liveDifferential[i] = 0.0f;
                }
                for (i = 0; i < this._device.getCounterCount(); ++i) {
                    this._liveCounter[i] = 0L;
                }
                for (i = 0; i < this._device.getDigiportCount(); ++i) {
                    this._liveDigiport[i] = 0;
                }
                this._daqActive = true;
                ArrayList<Input> inputs = new ArrayList<Input>();
                for (ISource s : sources) {
                    inputs.add(this.getInputOfSource(s));
                }
                this._realDevice.setupInputFrame(inputs.toArray(new Input[inputs.size()]));
                if (cfg.getCaptureMode() == 1) {
                    switch (cfg.getTriggerMode()) {
                        case 0: {
                            ((Trigger)this._realDevice.getTriggers().get(0)).setConfig(Trigger.TriggerConfig.InputRisingEdge);
                            break;
                        }
                        case 1: {
                            ((Trigger)this._realDevice.getTriggers().get(0)).setConfig(Trigger.TriggerConfig.InputFallingEdge);
                            break;
                        }
                        case 2: {
                            ((Trigger)this._realDevice.getTriggers().get(0)).setConfig(Trigger.TriggerConfig.InputAlternating);
                        }
                    }
                    if (this._realDevice.getDeviceType() == DeviceType.CeboStick) {
                        ((Trigger)this._realDevice.getTriggers().get(0)).setEnabled(true);
                    }
                    this._realDevice.startContinuousExternalTimedDataAcquisition();
                } else {
                    if (cfg.isOutputTrigger()) {
                        switch (cfg.getTriggerMode()) {
                            case 0: {
                                ((Trigger)this._realDevice.getTriggers().get(0)).setConfig(Trigger.TriggerConfig.OutputPulse);
                                break;
                            }
                            case 1: {
                                ((Trigger)this._realDevice.getTriggers().get(0)).setConfig(Trigger.TriggerConfig.OutputAlternating);
                            }
                        }
                    }
                    if (this._realDevice.getDeviceType() == DeviceType.CeboStick) {
                        ((Trigger)this._realDevice.getTriggers().get(0)).setEnabled(false);
                    }
                    if (!hostTriggered) {
                        this._realDevice.startContinuousDataAcquisition((float)cfg.getFrequency(), false);
                    }
                }
                List<IGenerateSample> els = this.createFrameExtractors(sources);
                long nextHTTS = lastTS = System.currentTimeMillis();
                long stepHT = (long)(1000.0 / cfg.getFrequency());
                while (!control.isTerminationRequested()) {
                    List<InputFrame> frames = null;
                    if (hostTriggered) {
                        if (System.currentTimeMillis() >= nextHTTS) {
                            frames = Arrays.asList(this._realDevice.readFrame());
                            nextHTTS += stepHT;
                        }
                    } else {
                        frames = this._realDevice.readNonBlocking();
                    }
                    if (frames != null) {
                        this.storeFrames(writer, els, frames, cfg, lastTS, startTime);
                    }
                    lastTS = System.currentTimeMillis();
                    Thread.sleep(1L);
                }
                this._realDevice.stopDataAcquisition();
            }
            finally {
                this._daqActive = false;
            }
        }
    }

    private void storeFrames(IDataWriter writer, List<IGenerateSample> els, List<InputFrame> frames, CeboMsrConfig cfg, long lastTS, long startTime) {
        block5: {
            block4: {
                if (cfg.getCaptureMode() != 0) break block4;
                for (InputFrame frame : frames) {
                    ArrayList<Sample> s = new ArrayList<Sample>();
                    for (IGenerateSample gs : els) {
                        s.add(gs.generate(frame));
                    }
                    writer.writeSet(this._currentFrame++, s);
                }
                break block5;
            }
            if (frames.isEmpty()) break block5;
            long duration = System.currentTimeMillis() - lastTS;
            long steps = (duration *= 1000000L) / (long)frames.size();
            long current = (lastTS - startTime) * 1000000L;
            for (InputFrame frame : frames) {
                ArrayList<Sample> s = new ArrayList<Sample>();
                for (IGenerateSample gs : els) {
                    s.add(gs.generate(frame));
                }
                writer.writeSet(this._currentFrame++, current, s);
                current += steps;
            }
        }
    }

    private List<IGenerateSample> createFrameExtractors(List<ISource> sources) {
        ArrayList<IGenerateSample> els = new ArrayList<IGenerateSample>();
        for (final ISource s : sources) {
            if (s instanceof CeboMsrAnalogInput) {
                els.add(new IGenerateSample(){

                    @Override
                    public Sample generate(InputFrame frame) {
                        float value;
                        CeboMsrAnalogInput ai = (CeboMsrAnalogInput)s;
                        if (ai.isSingleEnded()) {
                            float value2;
                            ((CeboMsrDevice)CeboMsrDevice.this)._liveSingleEnded[ai.getIndex()] = value2 = frame.getSingleEnded(ai.getIndex());
                            return new Sample(value2, "V");
                        }
                        ((CeboMsrDevice)CeboMsrDevice.this)._liveDifferential[ai.getIndex()] = value = frame.getDifferential(ai.getIndex());
                        return new Sample(value, "V");
                    }
                });
            }
            if (s instanceof CeboMsrDigitalPort) {
                els.add(new IGenerateSample(){

                    @Override
                    public Sample generate(InputFrame frame) {
                        byte value;
                        CeboMsrDigitalPort dp = (CeboMsrDigitalPort)s;
                        ((CeboMsrDevice)CeboMsrDevice.this)._liveDigiport[dp.getIndex()] = value = (byte)(frame.getDigitalPort(dp.getIndex()) & 0xFF);
                        return new Sample(value, null);
                    }
                });
            }
            if (!(s instanceof CeboMsrCounter)) continue;
            els.add(new IGenerateSample(){

                @Override
                public Sample generate(InputFrame frame) {
                    long value;
                    CeboMsrCounter c = (CeboMsrCounter)s;
                    ((CeboMsrDevice)CeboMsrDevice.this)._liveCounter[c.getIndex()] = value = frame.getCounter(c.getIndex());
                    return new Sample(value, null);
                }
            });
        }
        return els;
    }

    @Override
    public long maxFramesFor(long duration) {
        long l = (long)((double)duration / 1000.0 * this._device.getConfig().getFrequency());
        return l < 1L ? 1L : l;
    }

    private static interface IGenerateSample {
        public Sample generate(InputFrame var1);
    }
}

