/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.cebomsr;

import com.hobb1t.xml2.XElement;
import java.util.Arrays;
import java.util.List;

public class CeboMsrConfig {
    private final int _captureMode;
    private final int _triggerMode;
    private final double _frequency;
    private final boolean _outputTrigger;
    public static final int CM_FREQUENCY = 0;
    public static final int CM_EXTERNAL = 1;
    public static final int TMO_PULSE = 0;
    public static final int TMO_ALTERNATING = 1;
    public static final int TMI_RISING = 0;
    public static final int TMI_FALLING = 1;
    public static final int TMI_ALTERNATING = 2;

    public int getCaptureMode() {
        return this._captureMode;
    }

    public int getTriggerMode() {
        return this._triggerMode;
    }

    public double getFrequency() {
        return this._frequency;
    }

    public boolean isOutputTrigger() {
        return this._outputTrigger;
    }

    public CeboMsrConfig() {
        this(0, 0, 1000.0, false);
    }

    public CeboMsrConfig(int captureMode, int triggerMode, double frequency, boolean outputTrigger) {
        this._captureMode = captureMode;
        this._triggerMode = triggerMode;
        this._frequency = frequency;
        this._outputTrigger = outputTrigger;
    }

    public List<XElement> asXml() {
        XElement r = new XElement("cebocfg");
        r.setAttribute("capturemode", this._captureMode);
        r.setAttribute("triggermode", this._triggerMode);
        r.setAttribute("frequency", this._frequency);
        r.setAttribute("outputtrigger", this._outputTrigger);
        return Arrays.asList(r);
    }

    public static CeboMsrConfig fromXml(List<XElement> config) {
        XElement x;
        CeboMsrConfig defaults = new CeboMsrConfig();
        if (!config.isEmpty() && (x = config.get(0)).getName().equals("cebocfg")) {
            return new CeboMsrConfig(x.getAttribute("capturemode", 0), x.getAttribute("triggermode", 0), x.getAttribute("frequency", 1000.0), x.getAttribute("outputtrigger", false));
        }
        return defaults;
    }
}

