/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.cebomsr;

import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrDevice;
import com.cesys.apps.cebomultilogger.plugins.AbstractAnalogSource;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IRange;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import java.io.IOException;
import java.util.List;

public class CeboMsrAnalogInput
extends AbstractAnalogSource {
    private final boolean _singleEnded;
    private final int _id;
    private final List<IRange> _ranges;
    private IRange _range;
    private final CeboMsrDevice _device;

    boolean isSingleEnded() {
        return this._singleEnded;
    }

    int getIndex() {
        return this._id;
    }

    @Override
    public String getTypeName() {
        if (this._singleEnded) {
            return "AI-" + this._id;
        }
        return "AI-" + this._id * 2 + " / AI-" + (this._id * 2 + 1);
    }

    @Override
    public Sample.Type getSampleType() {
        return Sample.Type.FLOAT;
    }

    @Override
    public String getUnit() {
        return "V";
    }

    @Override
    public IDevice getDevice() {
        return this._device;
    }

    @Override
    public Sample getCurrentValue() throws IOException {
        return new Sample(this._singleEnded ? this._device.readSingleEnded(this._id, this._range.getId()) : this._device.readDifferential(this._id, this._range.getId()), "V");
    }

    @Override
    public List<IRange> getRanges() {
        return this._ranges;
    }

    @Override
    public void setRange(IRange range) {
        this._range = range;
        this.setModified("Range changed");
    }

    @Override
    public IRange getRange() {
        return this._range;
    }

    CeboMsrAnalogInput(boolean singleEnded, int id, List<IRange> ranges, CeboMsrDevice device) {
        this._singleEnded = singleEnded;
        this._id = id;
        this._ranges = ranges;
        this._range = this._ranges.get(0);
        this._device = device;
    }
}

