/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger.cebomsr;

import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrAnalogInput;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrConfig;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrCounter;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrDevice;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrDigitalPort;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrDlg;
import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrRange;
import com.cesys.apps.cebomultilogger.cebomsr.ICeboMsrDeviceClass;
import com.cesys.apps.cebomultilogger.plugins.IAnalogSource;
import com.cesys.apps.cebomultilogger.plugins.IDigitalSource;
import com.cesys.apps.cebomultilogger.plugins.IRange;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

class CeboLC
implements ICeboMsrDeviceClass {
    private CeboMsrConfig _cfg = new CeboMsrConfig();

    CeboLC() {
    }

    private List<IRange> getRanges(boolean singleEnded) {
        ArrayList<IRange> r = new ArrayList<IRange>();
        for (int i = 0; i < 4; ++i) {
            float maxValue = (float)(10.0 / Math.pow(10.0, i));
            float f = maxValue * (float)(singleEnded ? 1 : 2);
            String name = f < 1.0f ? "\u00b1 " + NumberSupport.UI.toUnitString(f * 1000.0f, 0, "mV") : "\u00b1 " + NumberSupport.UI.toUnitString(f, 0, "V");
            r.add(new CeboMsrRange(i, name));
        }
        return r;
    }

    @Override
    public String getTypeName() {
        return "CeboLC";
    }

    @Override
    public ICeboMsrDeviceClass cloneInstance() {
        return new CeboLC();
    }

    @Override
    public boolean configure(Shell parent) {
        CeboMsrConfig cfg = (CeboMsrConfig)new CeboMsrDlg(parent, this._cfg).open();
        if (cfg != null) {
            this._cfg = cfg;
            return true;
        }
        return false;
    }

    @Override
    public CeboMsrConfig getConfig() {
        return this._cfg;
    }

    @Override
    public void setConfig(CeboMsrConfig config) {
        this._cfg = config;
    }

    @Override
    public List<IAnalogSource> getAnalogSources(CeboMsrDevice parent) {
        int i;
        ArrayList<IAnalogSource> r = new ArrayList<IAnalogSource>();
        for (i = 0; i < 14; ++i) {
            r.add(new CeboMsrAnalogInput(true, i, this.getRanges(true), parent));
        }
        r.add(null);
        for (i = 0; i < 7; ++i) {
            r.add(new CeboMsrAnalogInput(false, i, this.getRanges(false), parent));
        }
        return r;
    }

    @Override
    public List<IDigitalSource> getDigitalSources(CeboMsrDevice parent) {
        int i;
        ArrayList<IDigitalSource> r = new ArrayList<IDigitalSource>();
        for (i = 0; i < 3; ++i) {
            r.add(new CeboMsrDigitalPort(i, parent));
        }
        r.add(null);
        for (i = 0; i < 1; ++i) {
            r.add(new CeboMsrCounter(i, parent));
        }
        return r;
    }

    @Override
    public int getSingleEndedCount() {
        return 14;
    }

    @Override
    public int getDifferentialCount() {
        return 7;
    }

    @Override
    public int getCounterCount() {
        return 1;
    }

    @Override
    public int getDigiportCount() {
        return 3;
    }
}

