/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.Global;
import com.cesys.apps.cebomultilogger.ICaptureReporter;
import com.cesys.apps.cebomultilogger.plugins.IDataWriter;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;

public class WriteCache
implements IDataWriter,
Runnable {
    private final ICaptureReporter _reporter;
    private final String _name;
    private final String _outputPath;
    private final int _devId;
    private final int _maxWaitTime;
    private final int _maxCollectSize;
    private final long _maxFileSize;
    private final long _maxFrames;
    private volatile boolean _terminate = false;
    private Thread _thread;
    private int _currentChunk = 0;
    private long _currentChunkSize = 0L;
    private long _lastWritten = System.currentTimeMillis();
    private ByteArrayOutputStream _collector = null;
    private DataOutputStream _dos = null;
    private final ArrayList<ByteArrayOutputStream> _write = new ArrayList();
    private final AtomicBoolean _done = new AtomicBoolean(false);

    private void createNewCollector() {
        this._collector = new ByteArrayOutputStream();
        this._dos = new DataOutputStream(this._collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToWrite() {
        ByteArrayOutputStream b = null;
        Object object = this;
        synchronized (object) {
            b = this._collector;
            try {
                b.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.createNewCollector();
            this._lastWritten = System.currentTimeMillis();
        }
        object = this._write;
        synchronized (object) {
            this._write.add(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite() {
        ArrayList<ByteArrayOutputStream> c = new ArrayList<ByteArrayOutputStream>();
        ArrayList<ByteArrayOutputStream> arrayList = this._write;
        synchronized (arrayList) {
            c.addAll(this._write);
            this._write.clear();
        }
        if (!c.isEmpty()) {
            for (ByteArrayOutputStream b : c) {
                String s = Global.INSTANCE.getDataFileName(this._outputPath, this._devId, this._currentChunk);
                try {
                    FileUtils.writeByteArrayToFile((File)new File(s), (byte[])b.toByteArray(), (boolean)true);
                }
                catch (IOException ex) {
                    this._reporter.setError(ex);
                }
                this._reporter.addRecordAmount(b.size());
                this._currentChunkSize += (long)b.size();
                if (this._currentChunkSize <= this._maxFileSize) continue;
                this._currentChunkSize = 0L;
                ++this._currentChunk;
            }
        }
    }

    public WriteCache(ICaptureReporter reporter, String name, String outputPath, int devId, int maxWaitTime, int maxCollectSize, long maxFileSize, long maxFrames) {
        this._reporter = reporter;
        this._name = name;
        this._outputPath = outputPath;
        this._devId = devId;
        this._maxWaitTime = maxWaitTime;
        this._maxCollectSize = maxCollectSize;
        this._maxFileSize = maxFileSize;
        this._maxFrames = maxFrames;
        this.createNewCollector();
        this._thread = new Thread((Runnable)this, "CaptureWriter: " + this._name);
        this._thread.start();
    }

    @Override
    public void terminate() {
        this.copyToWrite();
        this._terminate = true;
        try {
            this._thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSet(long currentFrame, List<Sample> samples) {
        if (currentFrame > this._maxFrames) {
            this._done.set(true);
            return;
        }
        WriteCache writeCache = this;
        synchronized (writeCache) {
            try {
                for (Sample s : samples) {
                    switch (s.getType()) {
                        case STRING: {
                            throw new IOException("String saving not supported");
                        }
                        case BYTE: {
                            this._dos.writeByte(s.getNumber().byteValue());
                            break;
                        }
                        case SHORT: {
                            this._dos.writeShort(s.getNumber().shortValue());
                            break;
                        }
                        case INT: {
                            this._dos.writeInt(s.getNumber().intValue());
                            break;
                        }
                        case LONG: {
                            this._dos.writeLong(s.getNumber().longValue());
                            break;
                        }
                        case FLOAT: {
                            this._dos.writeFloat(s.getNumber().floatValue());
                            break;
                        }
                        case DOUBLE: {
                            this._dos.writeDouble(s.getNumber().doubleValue());
                        }
                    }
                }
                if (this._dos.size() >= this._maxCollectSize) {
                    this.copyToWrite();
                }
            }
            catch (IOException ex) {
                this._reporter.setError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSet(long currentFrame, long timeStamp, List<Sample> samples) {
        if (this._done.get()) {
            return;
        }
        WriteCache writeCache = this;
        synchronized (writeCache) {
            try {
                this._dos.writeLong(timeStamp);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this._reporter.setError(ex);
            }
            this.writeSet(currentFrame, samples);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._terminate) {
            long lastWritten;
            WriteCache writeCache = this;
            synchronized (writeCache) {
                lastWritten = this._lastWritten;
            }
            if (System.currentTimeMillis() - lastWritten > (long)this._maxWaitTime) {
                this.copyToWrite();
            }
            this.doWrite();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.copyToWrite();
        this.doWrite();
    }

    @Override
    public boolean isDone() {
        return this._done.get();
    }
}

