/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.ICaptureReporter;
import com.cesys.apps.cebomultilogger.Project;
import com.cesys.apps.cebomultilogger.RecordThread;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import com.hobb1t.xml2.XElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class Recorder
implements ICaptureReporter {
    private final String _outputPath;
    private final XElement _data = new XElement("data");
    private final long _start;
    private final long _end;
    private final ArrayList<RecordThread> _threads = new ArrayList();
    private Throwable _error = null;
    private long _bytesRecorded = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setError(Throwable t) {
        Recorder recorder = this;
        synchronized (recorder) {
            this._error = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecordAmount(long bytes) {
        Recorder recorder = this;
        synchronized (recorder) {
            this._bytesRecorded += bytes;
        }
    }

    public Recorder(Project project, String outputPath, long start) {
        this._outputPath = outputPath;
        this._start = start;
        this._end = this._start + project.getDuration();
        File f = new File(outputPath);
        if (!f.exists() && !f.mkdirs()) {
            this._error = new IOException("Can't create output directories.");
            return;
        }
        try {
            project.saveTo(FilenameUtils.concat((String)f.getAbsolutePath(), (String)"project.cmlpd"));
        }
        catch (IOException ex) {
            this._error = ex;
            return;
        }
        int id = 0;
        for (IDevice d : project.getDevices()) {
            List<ISource> sources = project.getSourcesOfDevice(d);
            if (sources.isEmpty()) continue;
            RecordThread t = new RecordThread(this, f.getAbsolutePath(), id, d, sources, start, project.getDuration());
            this._threads.add(t);
            ++id;
        }
    }

    public void cancel() throws IOException {
        this._data.setAttribute("start", this._start);
        this._data.setAttribute("duration", System.currentTimeMillis() - this._start);
        for (RecordThread t : this._threads) {
            t.terminate();
        }
        this._data.save(FilenameUtils.concat((String)this._outputPath, (String)"record.cmli"));
    }

    public boolean isDone() {
        for (RecordThread t : this._threads) {
            if (t.isDone()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasError() {
        Recorder recorder = this;
        synchronized (recorder) {
            return this._error != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getError() {
        Recorder recorder = this;
        synchronized (recorder) {
            return this._error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesRecorded() {
        Recorder recorder = this;
        synchronized (recorder) {
            return this._bytesRecorded;
        }
    }

    public double getProgress() {
        long cur = System.currentTimeMillis() - this._start;
        long total = this._end - this._start;
        return (double)cur / (double)total;
    }
}

