/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.ICaptureReporter;
import com.cesys.apps.cebomultilogger.WriteCache;
import com.cesys.apps.cebomultilogger.plugins.ICaptureControl;
import com.cesys.apps.cebomultilogger.plugins.IDataWriter;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import java.util.List;

public class RecordThread
implements Runnable {
    private final ICaptureReporter _reporter;
    private final String _outputPath;
    private final int _devId;
    private final IDevice _device;
    private IDataWriter _writer = null;
    private final List<ISource> _sources;
    private final long _startTime;
    private final long _duration;
    private Thread _thread = null;
    private volatile boolean _terminate = false;

    public RecordThread(ICaptureReporter reporter, String outputPath, int devId, IDevice device, List<ISource> sources, long startTime, long duration) {
        this._reporter = reporter;
        this._outputPath = outputPath;
        this._devId = devId;
        this._device = device;
        this._sources = sources;
        this._startTime = startTime;
        this._duration = duration;
        this._thread = new Thread((Runnable)this, "Capture: " + this._device.getName());
        this._thread.start();
    }

    public void terminate() {
        this._terminate = true;
        try {
            this._thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        if (this._writer != null) {
            this._writer.terminate();
            this._writer = null;
        }
    }

    @Override
    public void run() {
        try {
            this._writer = new WriteCache(this._reporter, this._device.getName(), this._outputPath, this._devId, 1000, 65536, 0x100000L, this._device.maxFramesFor(this._duration));
            this._device.record(this._sources, new ICaptureControl(){

                @Override
                public boolean isTerminationRequested() {
                    return RecordThread.this._terminate;
                }
            }, this._writer, this._startTime);
        }
        catch (Throwable t) {
            this._reporter.setError(t);
        }
    }

    public boolean isDone() {
        IDataWriter writer = this._writer;
        if (writer != null) {
            return writer.isDone();
        }
        return false;
    }
}

