/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.DeviceDataReader;
import com.cesys.apps.cebomultilogger.Project;
import com.cesys.apps.cebomultilogger.plugins.IDataReader;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import com.hobb1t.xml2.XElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class Reader
implements IDataReader {
    private final Project _project = new Project();
    private long _start;
    private long _duration;
    private final List<DeviceDataReader> _dataReaders = new ArrayList<DeviceDataReader>();
    private final ArrayList<Sample> _currentValues = new ArrayList();

    public void load(String folder) throws IOException {
        this._project.load(FilenameUtils.concat((String)folder, (String)"project.cmlpd"));
        XElement info = XElement.load(FilenameUtils.concat((String)folder, (String)"record.cmli"));
        this._start = info.getAttribute("start", 0L);
        this._duration = Math.max(1L, info.getAttribute("duration", 0L));
        int devId = 0;
        for (IDevice d : this._project.getDevices()) {
            if (d.getFrequency() <= 0.0) {
                this._dataReaders.add(new DeviceDataReader(folder, d, devId++));
                continue;
            }
            this._dataReaders.add(new DeviceDataReader(folder, d, devId++, d.getFrequency()));
        }
        int idSo = 0;
        for (ISource s : this._project.getSources()) {
            devId = this._project.getDevices().indexOf(s.getDevice());
            this._dataReaders.get(devId).appendType(s.getSampleType(), idSo++, s);
            this._currentValues.add(new Sample(s.getSampleType(), ""));
        }
        for (DeviceDataReader dr : this._dataReaders) {
            dr.open();
        }
    }

    void close() {
        for (DeviceDataReader dr : this._dataReaders) {
            dr.close();
        }
    }

    @Override
    public DeviceDataReader getReaderOf(int index) {
        return this._dataReaders.get(index);
    }

    @Override
    public List<IDevice> getDevices() {
        return this._project.getDevices();
    }

    @Override
    public List<ISource> getSources() {
        return this._project.getSources();
    }

    @Override
    public String getProjectComment() {
        return this._project.getProjectComment();
    }

    @Override
    public long getStartTimeMs() {
        return this._start;
    }

    @Override
    public long getDurationMs() {
        return this._duration;
    }
}

