/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.PluginCentral;
import com.cesys.apps.cebomultilogger.export.CsvExport;
import com.cesys.apps.cebomultilogger.plugins.IAnalogSource;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IDeviceClass;
import com.cesys.apps.cebomultilogger.plugins.IExportPlugin;
import com.cesys.apps.cebomultilogger.plugins.IFormatting;
import com.cesys.apps.cebomultilogger.plugins.IObserver;
import com.cesys.apps.cebomultilogger.plugins.IProcessing;
import com.cesys.apps.cebomultilogger.plugins.IRange;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.hobb1t.xml2.XElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class Project
implements IObserver {
    private final ArrayList<IDevice> _devices = new ArrayList();
    private final ArrayList<ISource> _sources = new ArrayList();
    private String _projectComment;
    private String _outputPath;
    private long _duration;
    private boolean _autoExport;
    private boolean _overwrite;
    private IExportPlugin _exportPlugin;
    private final ArrayList<IModificationObserver> _observers = new ArrayList();
    private boolean _modified = false;
    private String _fileName = null;

    private void updateObservers() {
        for (IModificationObserver observer : this._observers) {
            observer.projectModified();
        }
    }

    private void setModified(String reason) {
        System.out.println("MOD: " + reason);
        this._modified = true;
        this.updateObservers();
    }

    private void clearProject() {
        this._fileName = null;
        this._modified = false;
        this._devices.clear();
        this._sources.clear();
        this._projectComment = "";
        this._outputPath = "";
        this._duration = 300000L;
        this._autoExport = false;
        this._overwrite = true;
        this._exportPlugin = new CsvExport();
    }

    public Project() {
        this.clearProject();
    }

    public void addModificationObserver(IModificationObserver observer) {
        this._observers.add(observer);
    }

    public boolean hasFileName() {
        return this._fileName != null;
    }

    public String getFileName() {
        return this._fileName;
    }

    public boolean isModified() {
        return this._modified;
    }

    public String getProjectComment() {
        return this._projectComment;
    }

    public void setProjectComment(String projectComment) {
        if (this._projectComment.equals(projectComment)) {
            return;
        }
        this._projectComment = projectComment;
        this.setModified("Comment changed");
        this.updateObservers();
    }

    public String getOutputPath() {
        return this._outputPath;
    }

    public void setOutputPath(String outputPath) {
        if (this._outputPath.equals(outputPath)) {
            return;
        }
        this._outputPath = outputPath;
        this.setModified("Output path changed");
        this.updateObservers();
    }

    public long getDuration() {
        return this._duration;
    }

    public void setDuration(long duration) {
        if (this._duration == duration) {
            return;
        }
        this._duration = duration;
        this.setModified("Duration changed");
        this.updateObservers();
    }

    public boolean isAutoExport() {
        return this._autoExport;
    }

    public void setAutoExport(boolean autoExport) {
        if (this._autoExport == autoExport) {
            return;
        }
        this._autoExport = autoExport;
        this.setModified("AutoExport toggled.");
        this.updateObservers();
    }

    public boolean isOverwrite() {
        return this._overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        if (this._overwrite == overwrite) {
            return;
        }
        this._overwrite = overwrite;
        this.setModified("Overwrite toggled.");
        this.updateObservers();
    }

    public IExportPlugin getExportPlugin() {
        return this._exportPlugin;
    }

    public void setExportPlugin(IExportPlugin plugin) {
        if (this._exportPlugin.getTypeName().equals(plugin.getTypeName())) {
            return;
        }
        this._exportPlugin = plugin;
        this.setModified("Export plugin changed.");
        this.updateObservers();
    }

    public String getActiveOutputPath(long captureStartTime) {
        if (this.isOverwrite()) {
            return new File(FilenameUtils.concat((String)this.getOutputPath(), (String)"_")).getAbsolutePath();
        }
        return new File(FilenameUtils.concat((String)this.getOutputPath(), (String)NumberSupport.EXPORT.convertSystemMillisToDateString(captureStartTime))).getAbsolutePath();
    }

    public void newProject() {
        this.clearProject();
        this.updateObservers();
    }

    public void saveAs(String fileName) throws IOException {
        this._fileName = fileName;
        this.updateObservers();
        this.save();
    }

    public void saveTo(String fileName) throws IOException {
        XElement p = new XElement("project");
        p.setAttribute("comment", this._projectComment);
        p.setAttribute("outputpath", this._outputPath);
        p.setAttribute("autoexport", this._autoExport);
        p.setAttribute("overwrite", this._overwrite);
        p.setAttribute("duration", this._duration);
        for (IDevice de : this._devices) {
            XElement d = new XElement("device");
            d.setAttribute("type", de.getTypeName());
            d.setAttribute("serial", de.getSerialNumber());
            d.setAttribute("name", de.getName());
            List<XElement> dc = de.getConfig();
            if (de != null) {
                for (XElement x : dc) {
                    d.add(x);
                }
            }
            p.add(d);
        }
        for (ISource so : this._sources) {
            XElement s = new XElement("source");
            s.setAttribute("device", so.getDevice().getName());
            s.setAttribute("type", so.getTypeName());
            s.setAttribute("name", so.getName());
            if (so instanceof IAnalogSource) {
                s.setAttribute("range", ((IAnalogSource)so).getRange().getId());
            }
            XElement f = new XElement("formatting");
            f.setAttribute("type", so.getFormatting().getTypeName());
            s.add(f);
            XElement pr = new XElement("processing");
            pr.setAttribute("type", so.getProcessing().getTypeName());
            List<XElement> prc = so.getProcessing().getConfig();
            if (prc != null) {
                for (XElement x : prc) {
                    pr.add(x);
                }
            }
            s.add(pr);
            p.add(s);
        }
        XElement s = new XElement("export");
        s.setAttribute("type", this._exportPlugin.getTypeName());
        List<XElement> eps = this._exportPlugin.getConfig();
        if (eps != null) {
            for (XElement x : eps) {
                s.add(x);
            }
        }
        p.add(s);
        p.save(fileName);
    }

    public void save() throws IOException {
        this.saveTo(this._fileName);
        this._modified = false;
        this.updateObservers();
    }

    public void load(String fileName) throws IOException {
        this.clearProject();
        this._fileName = fileName;
        this.updateObservers();
        try {
            Project defaults = new Project();
            XElement p = XElement.load(fileName);
            this._projectComment = p.getAttribute("comment", defaults.getProjectComment());
            this._outputPath = p.getAttribute("outputpath", defaults.getOutputPath());
            this._autoExport = p.getAttribute("autoexport", defaults.isAutoExport());
            this._overwrite = p.getAttribute("overwrite", defaults.isOverwrite());
            this._duration = p.getAttribute("duration", defaults.getDuration());
            for (XElement d : p.getElements("device")) {
                IDeviceClass dc;
                String type = d.getAttribute("type", "undefined");
                String serial = d.getAttribute("serial", "*");
                Object dev = null;
                Iterator<IDeviceClass> iterator = PluginCentral.INSTANCE.getDeviceClasses().iterator();
                while (iterator.hasNext() && (dev = (dc = iterator.next()).createInstanceOf(type, serial)) == null) {
                }
                if (dev == null) {
                    throw new IOException("Can't find plugin to handle device type: " + type);
                }
                dev.setName(d.getAttribute("name", "undefined"));
                dev.setConfig(Arrays.asList(d.getElements()));
                dev.addModificationObserver(this);
                this._devices.add((IDevice)dev);
            }
            for (XElement s : p.getElements("source")) {
                XElement f;
                String d = s.getAttribute("device", "undefined");
                IDevice dev = null;
                for (IDevice de : this._devices) {
                    if (!de.getName().equals(d)) continue;
                    dev = de;
                    break;
                }
                if (dev == null) {
                    throw new IOException("Source can't be mapped to device.");
                }
                ISource src = dev.createSourceByType(s.getAttribute("type", "undefined"));
                if (src == null) {
                    throw new IOException("Source type can't be created by device.");
                }
                src.setName(s.getAttribute("name", "undefined"));
                if (src instanceof IAnalogSource) {
                    IAnalogSource asrc = (IAnalogSource)src;
                    int rid = s.getAttribute("range", -1);
                    IRange rng = asrc.getRangeById(rid);
                    if (rng == null) {
                        throw new IOException("Range can't be mapped.");
                    }
                    asrc.setRange(rng);
                }
                if ((f = s.getFirstElement("formatting")) == null) {
                    throw new IOException("Formatting information missed.");
                }
                String ft = f.getAttribute("type", "undefined");
                IFormatting fom = null;
                for (IFormatting fo : PluginCentral.INSTANCE.getFormattingClasses()) {
                    if (!fo.getTypeName().equals(ft)) continue;
                    fom = fo;
                    break;
                }
                if (fom == null) {
                    throw new IOException("Formatting can't be mapped.");
                }
                src.setFormatting(fom);
                XElement pr = s.getFirstElement("processing");
                if (pr == null) {
                    throw new IOException("Processing information missed.");
                }
                String pt = pr.getAttribute("type", "undefined");
                IProcessing prc = null;
                for (IProcessing pro : PluginCentral.INSTANCE.getProcessingClasses()) {
                    if (!pro.getTypeName().equals(pt)) continue;
                    prc = pro.createInstance();
                    break;
                }
                if (prc == null) {
                    throw new IOException("Processing can't be mapped.");
                }
                prc.setConfig(Arrays.asList(pr.getElements()));
                src.setProcessing(prc);
                src.addModificationObserver(this);
                this._sources.add(src);
            }
            XElement e = p.getFirstElement("export");
            if (e != null) {
                String type = e.getAttribute("type", defaults.getExportPlugin().getTypeName());
                IExportPlugin epl = null;
                for (IExportPlugin ep : PluginCentral.INSTANCE.getExportPlugins()) {
                    if (!ep.getTypeName().equals(type)) continue;
                    epl = ep.createInstance();
                    break;
                }
                if (epl == null) {
                    throw new IOException("Unknown export plugin.");
                }
                epl.setConfig(Arrays.asList(e.getElements()));
                this._exportPlugin = epl;
            }
        }
        catch (IOException ex) {
            this.newProject();
            throw ex;
        }
        this._modified = false;
        this.updateObservers();
    }

    @Override
    public void modified(String reason) {
        this.setModified(reason);
    }

    public List<IDevice> getDevices() {
        return Collections.unmodifiableList(this._devices);
    }

    public void addDevice(IDevice device) {
        this._devices.add(device);
        device.addModificationObserver(this);
        this.setModified("Device added");
    }

    public void removeDevice(IDevice device) {
        this._devices.remove(device);
        ArrayList<ISource> safe = new ArrayList<ISource>();
        for (ISource s : this._sources) {
            if (s.getDevice() == device) continue;
            safe.add(s);
        }
        this._sources.clear();
        this._sources.addAll(safe);
        this.setModified("Device removed");
    }

    public List<ISource> getSources() {
        return Collections.unmodifiableList(this._sources);
    }

    public void addSource(ISource source) {
        this._sources.add(source);
        source.addModificationObserver(this);
        this.setModified("Source added");
    }

    public void removeSource(ISource source) {
        this._sources.remove(source);
        this.setModified("Source removed");
    }

    public void exchangeSource(ISource exchange, ISource s) {
        this._sources.set(this._sources.indexOf(exchange), s);
        s.addModificationObserver(this);
        this.setModified("Source exchanged");
    }

    public void moveSource(int srcPos, ISource target, boolean after) {
        ISource s = this._sources.get(srcPos);
        this._sources.remove(srcPos);
        this._sources.add(this._sources.indexOf(target) + (after ? 1 : 0), s);
        this.setModified("Source repositioned");
    }

    public boolean isSourceInUse(ISource source) {
        for (ISource s : this._sources) {
            if (s.getDevice() != source.getDevice() || !s.getTypeName().equals(source.getTypeName())) continue;
            return true;
        }
        return false;
    }

    public List<ISource> getSourcesOfDevice(IDevice device) {
        ArrayList<ISource> r = new ArrayList<ISource>();
        for (ISource s : this._sources) {
            if (s.getDevice() != device) continue;
            r.add(s);
        }
        return r;
    }

    public static interface IModificationObserver {
        public void projectModified();
    }
}

