/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.cebomsr.CeboMsrDeviceClass;
import com.cesys.apps.cebomultilogger.export.CsvExport;
import com.cesys.apps.cebomultilogger.formatting.BaseAnalogFormat;
import com.cesys.apps.cebomultilogger.formatting.DecBinFormat;
import com.cesys.apps.cebomultilogger.formatting.DecFormat;
import com.cesys.apps.cebomultilogger.formatting.DecHexFormat;
import com.cesys.apps.cebomultilogger.plugins.IDeviceClass;
import com.cesys.apps.cebomultilogger.plugins.IExportPlugin;
import com.cesys.apps.cebomultilogger.plugins.IFormatting;
import com.cesys.apps.cebomultilogger.plugins.IProcessing;
import com.cesys.apps.cebomultilogger.processing.FrequencyAnalyzer;
import com.cesys.apps.cebomultilogger.processing.PT1000;
import com.cesys.apps.cebomultilogger.processing.PassThrough;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public enum PluginCentral {
    INSTANCE;

    private final List<IDeviceClass> _deviceClasses = new ArrayList<IDeviceClass>();
    private final List<IFormatting> _formattingClasses = new ArrayList<IFormatting>();
    private final List<IProcessing> _processingClasses = new ArrayList<IProcessing>();
    private final List<IExportPlugin> _exportPlugins = new ArrayList<IExportPlugin>();

    void initialize(File sourceDir) {
        this._deviceClasses.add(new CeboMsrDeviceClass());
        this._formattingClasses.add(new BaseAnalogFormat.MediumPrecisionAnalogFormat());
        this._formattingClasses.add(new BaseAnalogFormat.HighPrecisionAnalogFormat());
        this._formattingClasses.add(new DecFormat());
        this._formattingClasses.add(new DecHexFormat());
        this._formattingClasses.add(new DecBinFormat());
        this._processingClasses.add(new PassThrough());
        this._processingClasses.add(new PT1000());
        this._processingClasses.add(new FrequencyAnalyzer());
        this._exportPlugins.add(new CsvExport());
    }

    public List<IDeviceClass> getDeviceClasses() {
        return this._deviceClasses;
    }

    public List<IFormatting> getFormattingClasses() {
        return this._formattingClasses;
    }

    public List<IProcessing> getProcessingClasses() {
        return this._processingClasses;
    }

    public List<IExportPlugin> getExportPlugins() {
        return this._exportPlugins;
    }
}

