/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.Config;
import com.cesys.apps.cebomultilogger.ConfigDlg;
import com.cesys.apps.cebomultilogger.DeviceDialog;
import com.cesys.apps.cebomultilogger.DurationDlg;
import com.cesys.apps.cebomultilogger.ExportProgressDlg;
import com.cesys.apps.cebomultilogger.Global;
import com.cesys.apps.cebomultilogger.PluginCentral;
import com.cesys.apps.cebomultilogger.Project;
import com.cesys.apps.cebomultilogger.Reader;
import com.cesys.apps.cebomultilogger.Recorder;
import com.cesys.apps.cebomultilogger.plugins.FormattingCategories;
import com.cesys.apps.cebomultilogger.plugins.IAnalogSource;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IDeviceClass;
import com.cesys.apps.cebomultilogger.plugins.IDigitalSource;
import com.cesys.apps.cebomultilogger.plugins.IExportPlugin;
import com.cesys.apps.cebomultilogger.plugins.IFormatting;
import com.cesys.apps.cebomultilogger.plugins.IProcessing;
import com.cesys.apps.cebomultilogger.plugins.IRange;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.apps.cebomultilogger.plugins.ProcessingCategories;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import com.cesys.apps.cebomultilogger.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.Transformer;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class MainWindow
implements Project.IModificationObserver {
    protected Shell _shell;
    private Project _project = new Project();
    private Recorder _recorder = null;
    private String _capturePath = null;
    private long _captureStartTime = 0L;
    private boolean _canUpdateTable = true;
    private Menu _menu;
    private MenuItem _mnuProject;
    private Menu _menu_1;
    private Composite _composite;
    private Composite _composite_1;
    private Composite _composite_2;
    private Table _tblMain;
    private TableViewer _tblvMain;
    private TableColumn _tblcDevice;
    private TableViewerColumn _tblvcDevice;
    private TableColumn _tblcInput;
    private TableViewerColumn _tblvcInput;
    private TableColumn _tblcRange;
    private TableViewerColumn _tblvcRange;
    private TableColumn _tblcProcessing;
    private TableViewerColumn _tblvcProcessing;
    private Label _label;
    private Label _lblStats;
    private Button _btnStart;
    private Button _btnSelectPath;
    private Label _lblOutputPath;
    private Button _btnAutoExport;
    private TableColumn _tblcCurrentValue;
    private TableViewerColumn _tblvcCurrentValue;
    private Button _btnExport;
    private Button _btnConfigExport;
    private TableColumn _tblcDummy;
    private TableViewerColumn _tblvcDummy;
    private Button _btnDuration;
    private ProgressBar _prgRecording;
    private Label _lblPercent;
    private MenuItem _mnuNewProject;
    private MenuItem _mnuLoadProject;
    private MenuItem _mnuSaveProject;
    private MenuItem _mnuSaveProjectAs;
    private MenuItem _mnuExit;
    private TableColumn _tblcName;
    private TableViewerColumn _tblvcName;
    private Text _txtProjectComment;
    private MenuItem _mnuConfig;
    private Button _btnOverwrite;
    private Combo _cmbExport;
    private ComboViewer _cmbvExport;

    private void onCaptureToggle(boolean start) {
        this._mnuProject.setEnabled(!start);
        this._txtProjectComment.setEnabled(!start);
        this._btnStart.setText(start ? "Stop" : "Start");
        this._btnStart.setImage(SWTResourceManager.getImage(this.getClass(), start ? "/com/cesys/apps/cebomultilogger/resources/Cancel.png" : "/com/cesys/apps/cebomultilogger/resources/Lightning.png"));
        this._btnSelectPath.setEnabled(!start);
        this._btnDuration.setEnabled(!start);
        this._btnAutoExport.setEnabled(!start);
        this._btnOverwrite.setEnabled(!start);
        this._btnExport.setEnabled(!start && this._project.getExportPlugin().isConfigurationValid());
        this._cmbExport.setEnabled(!start);
        this._btnConfigExport.setEnabled(!start && this.getCurrentExportPluginType().hasConfiguration());
        this._prgRecording.setSelection(0);
        if (start) {
            this._recorder = new Recorder(this._project, this._capturePath, this._captureStartTime);
        } else {
            try {
                this._recorder.cancel();
            }
            catch (IOException ex) {
                Utils.showExceptionBox(this._shell, "Failed to finalize recording.", ex);
            }
            this._recorder = null;
            if (this._project.isAutoExport()) {
                if (this._project.getExportPlugin().isConfigurationValid()) {
                    this.runExport();
                } else {
                    Utils.showErrorDialog(this._shell, "Export plugin has no valid configuration, Auto Export skipped.");
                }
            }
        }
    }

    private void runExport() {
        final IExceptionReporter exr = new IExceptionReporter(){
            public Exception _ex = null;

            @Override
            public void setException(Exception ex) {
                this._ex = ex;
            }

            @Override
            public Exception getException() {
                return this._ex;
            }
        };
        final ExportProgressDlg dlg = new ExportProgressDlg(this._shell);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try (Reader r = new Reader();){
                    r.load(MainWindow.this._capturePath);
                    MainWindow.this._project.getExportPlugin().export(dlg, r, NumberSupport.EXPORT.convertSystemMillisToDateString(r.getStartTimeMs()));
                }
            }
        };
        dlg.open(runner);
        if (exr.getException() != null) {
            Utils.showExceptionBox(this._shell, "Error exporting data.", exr.getException());
        }
    }

    private void resetExport() {
        this._captureStartTime = 0L;
        this._capturePath = null;
        this._btnExport.setEnabled(false);
    }

    private void mapDevices() {
        for (IDeviceClass dc : PluginCentral.INSTANCE.getDeviceClasses()) {
            ArrayList<IDevice> l = new ArrayList<IDevice>();
            for (IDevice d : this._project.getDevices()) {
                if (!dc.isCompatibleDevice(d)) continue;
                l.add(d);
            }
            try {
                dc.mapInstances(l);
            }
            catch (IOException ex) {
                Utils.showExceptionBox(this._shell, "Error mapping devices.", ex);
            }
        }
    }

    private void unmapDevices() {
        for (IDeviceClass dc : PluginCentral.INSTANCE.getDeviceClasses()) {
            ArrayList<IDevice> l = new ArrayList<IDevice>();
            for (IDevice d : this._project.getDevices()) {
                if (!dc.isCompatibleDevice(d)) continue;
                l.add(d);
            }
            try {
                dc.unmapInstances(l);
            }
            catch (IOException ex) {
                Utils.showExceptionBox(this._shell, "Error mapping devices.", ex);
            }
        }
    }

    private IExportPlugin getCurrentExportPluginType() {
        return ((IExportPlugin)((IStructuredSelection)this._cmbvExport.getSelection()).getFirstElement()).createInstance();
    }

    private String formatInputValue(ISource e) throws IOException {
        Sample s = null;
        s = e instanceof IAnalogSource ? ((IAnalogSource)e).getCurrentValue() : ((IDigitalSource)e).getCurrentValue();
        IProcessing prc = e.getProcessing();
        Sample res = prc.transformValue(s, -1L, e.getDevice(), true);
        if (res.getType() == Sample.Type.STRING) {
            return res.getString();
        }
        return e.getFormatting().format(res);
    }

    private String getNextAutoName() {
        int i = 0;
        while (true) {
            String name = "Source " + i;
            boolean found = false;
            for (ISource d : this._project.getSources()) {
                if (!d.getName().equals(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                return name;
            }
            ++i;
        }
    }

    private void fillFormattingMenu(Menu menu, final ISource source) {
        ArrayList<FormattingCategories> cats = new ArrayList<FormattingCategories>();
        for (IFormatting p : PluginCentral.INSTANCE.getFormattingClasses()) {
            if (cats.contains((Object)p.getCategory())) continue;
            cats.add(p.getCategory());
        }
        for (FormattingCategories cat : cats) {
            MenuItem c = new MenuItem(menu, 64);
            c.setText(cat.getName());
            c.setImage(SWTResourceManager.getImage(MainWindow.class, cat.getIcon()));
            Menu sub = new Menu(menu);
            for (final IFormatting f : PluginCentral.INSTANCE.getFormattingClasses()) {
                if (!f.getCategory().equals((Object)cat)) continue;
                MenuItem mi = new MenuItem(sub, 0);
                mi.setText(f.getName());
                mi.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Component.png"));
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        source.setFormatting(f);
                        MainWindow.this._tblvMain.refresh();
                    }
                });
            }
            c.setMenu(sub);
        }
    }

    private void fillProcessingMenu(Menu menu, final ISource source) {
        ArrayList<ProcessingCategories> cats = new ArrayList<ProcessingCategories>();
        for (IProcessing p : PluginCentral.INSTANCE.getProcessingClasses()) {
            if (cats.contains((Object)p.getCategory())) continue;
            cats.add(p.getCategory());
        }
        for (ProcessingCategories cat : cats) {
            MenuItem c = new MenuItem(menu, 64);
            c.setText(cat.getName());
            c.setImage(SWTResourceManager.getImage(MainWindow.class, cat.getIcon()));
            Menu sub = new Menu(menu);
            for (final IProcessing p : PluginCentral.INSTANCE.getProcessingClasses()) {
                if (!p.getCategory().equals((Object)cat)) continue;
                MenuItem mi = new MenuItem(sub, 0);
                mi.setText(p.getName());
                mi.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Component.png"));
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        source.setProcessing(p.createInstance());
                        MainWindow.this._tblvMain.refresh();
                    }
                });
            }
            c.setMenu(sub);
        }
        if (source.getProcessing().hasConfiguration()) {
            new MenuItem(menu, 2);
            MenuItem mi = new MenuItem(menu, 0);
            mi.setText("Configure plugin");
            mi.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Wrench.png"));
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean modified = source.getProcessing().configure(MainWindow.this._shell);
                    if (modified) {
                        MainWindow.this._project.modified("Processing configuration changed");
                    }
                    MainWindow.this._tblvMain.refresh();
                }
            });
        }
    }

    private void fillSourcesToMenu(List<ISource> sources, Menu menu, IDevice device, final ISource exchange, String icon) {
        for (final ISource s : sources) {
            if (s == null) {
                new MenuItem(menu, 2);
                continue;
            }
            MenuItem mi = new MenuItem(menu, 0);
            mi.setText(s.getTypeName());
            mi.setImage(SWTResourceManager.getImage(MainWindow.class, icon));
            if (this._project.isSourceInUse(s)) {
                mi.setEnabled(false);
                continue;
            }
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (exchange == null) {
                        s.setName(MainWindow.this.getNextAutoName());
                        MainWindow.this._project.addSource(s);
                    } else {
                        s.setName(exchange.getName());
                        MainWindow.this._project.exchangeSource(exchange, s);
                    }
                    MainWindow.this._tblvMain.refresh();
                }
            });
        }
    }

    private void fillDeviceSubMenu(Menu menu, IDevice device, ISource exchange) {
        this.fillSourcesToMenu(ListUtils.transformedList(device.getAnalogSources(), (Transformer)new ToISourceTransformer()), menu, device, exchange, "/com/cesys/apps/cebomultilogger/resources/oscilloscope.png");
        new MenuItem(menu, 2);
        this.fillSourcesToMenu(ListUtils.transformedList(device.getDigitalSources(), (Transformer)new ToISourceTransformer()), menu, device, exchange, "/com/cesys/apps/cebomultilogger/resources/greenled.png");
    }

    private void fillDeviceMenu(Menu menu) {
        for (IDevice d : this._project.getDevices()) {
            MenuItem mi = new MenuItem(menu, 64);
            mi.setText(String.format("%s (%s / %s)", d.getName(), d.getTypeName(), d.getSerialNumber()));
            mi.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Hard disk.png"));
            Menu m = new Menu(menu);
            mi.setMenu(m);
            this.fillDeviceSubMenu(m, d, null);
        }
    }

    private void fillRangeMenu(Menu menu, final IAnalogSource source) {
        for (final IRange r : source.getRanges()) {
            MenuItem mi = new MenuItem(menu, 0);
            mi.setText(r.getName());
            mi.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Up-down.png"));
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    source.setRange(r);
                    MainWindow.this._tblvMain.refresh();
                }
            });
        }
    }

    private void init() {
        this._shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (MainWindow.this._recorder != null) {
                    Utils.showErrorDialog(MainWindow.this._shell, "Acquisition active, please stop first !");
                    event.doit = false;
                    return;
                }
                if (MainWindow.this._project.isModified() && !Utils.showYesNoDialog(MainWindow.this._shell, "Project modified, discard changes ?")) {
                    event.doit = false;
                    return;
                }
                MainWindow.this.unmapDevices();
            }
        });
        this._mnuNewProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainWindow.this._project.isModified() && !Utils.showYesNoDialog(MainWindow.this._shell, "Project modified, discard changes ?")) {
                    return;
                }
                MainWindow.this.unmapDevices();
                MainWindow.this._project.newProject();
                MainWindow.this._tblvMain.refresh();
                MainWindow.this.resetExport();
            }
        });
        this._mnuLoadProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainWindow.this._project.isModified() && !Utils.showYesNoDialog(MainWindow.this._shell, "Project modified, discard changes ?")) {
                    return;
                }
                String fileName = Utils.showFileOpenDialog(MainWindow.this._shell, "Select file to open.", new String[]{"*.cmlp"});
                if (fileName == null) {
                    return;
                }
                MainWindow.this.unmapDevices();
                try {
                    MainWindow.this._project.load(fileName);
                }
                catch (IOException ex) {
                    Utils.showExceptionBox(MainWindow.this._shell, "Problem loading project.", ex);
                }
                MainWindow.this.mapDevices();
                MainWindow.this._tblvMain.refresh();
                MainWindow.this.resetExport();
            }
        });
        this._mnuSaveProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MainWindow.this._project.save();
                }
                catch (IOException ex) {
                    Utils.showExceptionBox(MainWindow.this._shell, "Problem saving project.", ex);
                }
            }
        });
        this._mnuSaveProjectAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileName = Utils.showFileSaveDialog(MainWindow.this._shell, "Select file to save.", new String[]{"*.cmlp"});
                if (fileName == null) {
                    return;
                }
                try {
                    MainWindow.this._project.saveAs(fileName);
                }
                catch (IOException ex) {
                    Utils.showExceptionBox(MainWindow.this._shell, "Problem saving project.", ex);
                }
            }
        });
        this._mnuConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ConfigDlg(MainWindow.this._shell).open();
            }
        });
        this._mnuExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this._shell.close();
            }
        });
        this._txtProjectComment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainWindow.this._project.setProjectComment(MainWindow.this._txtProjectComment.getText());
            }
        });
        this._tblvMain.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Project)inputElement).getSources().toArray();
            }
        });
        this._tblvMain.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                int column = cell.getColumnIndex();
                ISource e = (ISource)cell.getElement();
                switch (column) {
                    case 1: {
                        cell.setText(e.getName());
                        break;
                    }
                    case 2: {
                        cell.setText(String.format("%s (%s)", e.getDevice().getName(), e.getDevice().getTypeName()));
                        break;
                    }
                    case 3: {
                        cell.setText(e.getTypeName());
                        break;
                    }
                    case 4: {
                        if (e instanceof IAnalogSource) {
                            cell.setText(((IAnalogSource)e).getRange().getName());
                            break;
                        }
                        cell.setText("-");
                        break;
                    }
                    case 5: {
                        try {
                            cell.setText(MainWindow.this.formatInputValue(e));
                            if (e.getDevice().isMapped()) {
                                cell.setForeground(MainWindow.this._shell.getDisplay().getSystemColor(24));
                                break;
                            }
                            cell.setForeground(SWTResourceManager.getColor(255, 0, 0));
                        }
                        catch (Throwable ex) {
                            cell.setText("???");
                        }
                        break;
                    }
                    case 6: {
                        String params = e.getProcessing().getParamInfo();
                        if (params == null) {
                            cell.setText(e.getProcessing().getName());
                            break;
                        }
                        cell.setText(e.getProcessing().getName() + " (" + params + ")");
                    }
                }
            }
        });
        int dndOperations = 2;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this._tblvMain.addDragSupport(dndOperations, transfers, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)MainWindow.this._tblvMain.getSelection();
                ISource firstElement = (ISource)selection.getFirstElement();
                List<ISource> lst = ((Project)MainWindow.this._tblvMain.getInput()).getSources();
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = String.format("###CML%d", lst.indexOf(firstElement));
                }
            }
        });
        this._tblvMain.addDropSupport(dndOperations, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this._tblvMain){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (MainWindow.this._recorder != null) {
                    return false;
                }
                return target instanceof ISource;
            }

            public boolean performDrop(Object data) {
                String e = (String)data;
                if (!e.startsWith("###CML")) {
                    return false;
                }
                int dragPos = Integer.parseInt(e.substring(6));
                List<ISource> lst = ((Project)MainWindow.this._tblvMain.getInput()).getSources();
                ISource target = (ISource)this.getCurrentTarget();
                if (target == null) {
                    return false;
                }
                int pos = lst.indexOf(target);
                if (pos == -1) {
                    return false;
                }
                if (pos == dragPos) {
                    return false;
                }
                boolean after = false;
                if (this.getCurrentLocation() == 2) {
                    after = true;
                }
                MainWindow.this._project.moveSource(dragPos, target, after);
                MainWindow.this._tblvMain.refresh();
                return true;
            }
        });
        this._tblMain.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                ViewerCell c = MainWindow.this._tblvMain.getCell(MainWindow.this._tblMain.toControl(e.x, e.y));
                Menu menu = new Menu((Control)MainWindow.this._tblMain);
                if (MainWindow.this._recorder != null) {
                    MenuItem mi = new MenuItem(menu, 0);
                    mi.setText("Not possible during acquisition");
                    mi.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Remove.png"));
                } else {
                    if (c == null) {
                        MainWindow.this.fillDeviceMenu(menu);
                        if (!MainWindow.this._project.getDevices().isEmpty()) {
                            new MenuItem(menu, 2);
                        }
                    } else {
                        final ISource s = (ISource)c.getElement();
                        boolean valid = false;
                        if (c.getColumnIndex() == 6) {
                            MainWindow.this.fillProcessingMenu(menu, s);
                            valid = true;
                        } else if (c.getColumnIndex() == 5) {
                            MainWindow.this.fillFormattingMenu(menu, s);
                            valid = true;
                        } else if (c.getColumnIndex() == 4) {
                            if (s instanceof IAnalogSource) {
                                MainWindow.this.fillRangeMenu(menu, (IAnalogSource)s);
                                valid = true;
                            }
                        } else if (c.getColumnIndex() == 3) {
                            MainWindow.this.fillDeviceSubMenu(menu, s.getDevice(), s);
                            valid = true;
                        }
                        if (valid) {
                            new MenuItem(menu, 2);
                        }
                        MenuItem rs = new MenuItem(menu, 0);
                        rs.setText("Remove source");
                        rs.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Remove.png"));
                        rs.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (Utils.showYesNoDialog(MainWindow.this._shell, "Remove source ?")) {
                                    MainWindow.this._project.removeSource(s);
                                    MainWindow.this._tblvMain.refresh();
                                }
                            }
                        });
                        MenuItem rd = new MenuItem(menu, 0);
                        rd.setText("Remove device");
                        rd.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Trash.png"));
                        rd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (Utils.showYesNoDialog(MainWindow.this._shell, "Remove device ?")) {
                                    MainWindow.this.unmapDevices();
                                    MainWindow.this._project.removeDevice(s.getDevice());
                                    MainWindow.this._tblvMain.refresh();
                                    MainWindow.this.mapDevices();
                                }
                            }
                        });
                        new MenuItem(menu, 2);
                    }
                    MenuItem cd = new MenuItem(menu, 0);
                    cd.setText("Configure devices");
                    cd.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Equipment.png"));
                    cd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            MainWindow.this.unmapDevices();
                            new DeviceDialog(MainWindow.this._shell, MainWindow.this._project).open();
                            MainWindow.this._tblvMain.refresh();
                            MainWindow.this.mapDevices();
                        }
                    });
                }
                menu.setLocation(e.x, e.y);
                menu.setVisible(true);
            }
        });
        this._tblvcName.setEditingSupport(new EditingSupport((ColumnViewer)this._tblvMain){

            protected void setValue(Object element, Object value) {
                MainWindow.this._canUpdateTable = true;
                ISource s = (ISource)element;
                String nn = (String)value;
                for (ISource d : MainWindow.this._project.getSources()) {
                    if (d == s || !nn.equals(d.getName())) continue;
                    Utils.showErrorDialog(MainWindow.this._shell, "Name already in use.");
                    return;
                }
                s.setName(nn);
                MainWindow.this._tblvMain.update(element, null);
            }

            protected Object getValue(Object element) {
                return ((ISource)element).getName();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)MainWindow.this._tblMain);
            }

            protected boolean canEdit(Object element) {
                if (element != null) {
                    MainWindow.this._canUpdateTable = false;
                    return true;
                }
                return false;
            }
        });
        this._tblvMain.setInput((Object)this._project);
        this._cmbExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IExportPlugin newType = MainWindow.this.getCurrentExportPluginType();
                MainWindow.this._btnConfigExport.setEnabled(newType.hasConfiguration());
                MainWindow.this._project.setExportPlugin(newType);
            }
        });
        this._cmbvExport.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((PluginCentral)((Object)inputElement)).getExportPlugins().toArray();
            }
        });
        this._cmbvExport.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IExportPlugin)element).getTypeName();
            }
        });
        this._cmbvExport.setInput((Object)PluginCentral.INSTANCE);
        this._cmbExport.select(0);
        this._btnConfigExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainWindow.this._project.getExportPlugin().configure(MainWindow.this._shell)) {
                    MainWindow.this._project.modified("Export plugin settings changed.");
                    MainWindow.this._btnExport.setEnabled(MainWindow.this._project.getExportPlugin().isConfigurationValid() && MainWindow.this._capturePath != null);
                }
            }
        });
        this._btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.runExport();
            }
        });
        this._btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainWindow.this._recorder == null) {
                    if (MainWindow.this._project.getSources().isEmpty()) {
                        Utils.showErrorDialog(MainWindow.this._shell, "No single source selected.");
                        return;
                    }
                    if (MainWindow.this._project.getOutputPath().isEmpty()) {
                        Utils.showErrorDialog(MainWindow.this._shell, "No output path specified.");
                        return;
                    }
                    MainWindow.this._captureStartTime = System.currentTimeMillis();
                    String capturePath = MainWindow.this._project.getActiveOutputPath(MainWindow.this._captureStartTime);
                    File[] files = new File(capturePath).listFiles();
                    if (files != null && files.length != 0) {
                        if (Utils.showYesNoDialog(MainWindow.this._shell, "Directory already contains capture data, remove files ?")) {
                            for (File f : files) {
                                f.delete();
                            }
                        } else {
                            return;
                        }
                    }
                    MainWindow.this._capturePath = capturePath;
                }
                MainWindow.this.onCaptureToggle(MainWindow.this._recorder == null);
            }
        });
        this._btnSelectPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String r = Utils.showFolderSelectionDialog(MainWindow.this._shell, "Select output folder");
                if (r != null) {
                    MainWindow.this._project.setOutputPath(r);
                }
            }
        });
        this._btnDuration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long newDuration = new DurationDlg(MainWindow.this._shell, MainWindow.this._project.getDuration()).open();
                if (newDuration > 0L) {
                    MainWindow.this._project.setDuration(newDuration);
                }
            }
        });
        this._btnAutoExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this._project.setAutoExport(MainWindow.this._btnAutoExport.getSelection());
            }
        });
        this._btnOverwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this._project.setOverwrite(MainWindow.this._btnOverwrite.getSelection());
            }
        });
        this.projectModified();
        this._lblPercent.setText(NumberSupport.UI.toUnitString(0.0, 1, "%"));
        Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (MainWindow.this._shell.isDisposed()) {
                    return;
                }
                if (MainWindow.this._prgRecording.isDisposed()) {
                    return;
                }
                if (MainWindow.this._canUpdateTable) {
                    MainWindow.this._tblvMain.refresh();
                }
                double progress = 0.0;
                long bytesRecorded = 0L;
                if (MainWindow.this._recorder != null) {
                    progress = MainWindow.this._recorder.getProgress();
                    bytesRecorded = MainWindow.this._recorder.getBytesRecorded();
                    if (MainWindow.this._recorder.isDone()) {
                        MainWindow.this.onCaptureToggle(false);
                    }
                    if (MainWindow.this._recorder != null && MainWindow.this._recorder.hasError()) {
                        Throwable t = MainWindow.this._recorder.getError();
                        MainWindow.this.onCaptureToggle(false);
                        Utils.showExceptionBox(MainWindow.this._shell, "Error during data acquisition.", t);
                    }
                }
                MainWindow.this._prgRecording.setSelection((int)(progress * 1000.0));
                MainWindow.this._lblPercent.setText(String.format("%s / %s", NumberSupport.UI.toUnitString(progress * 100.0, 1, "%"), bytesRecorded == 0L ? "-" : NumberSupport.UI.toPrefixStringB(bytesRecorded, "B")));
                MainWindow.this._shell.getDisplay().timerExec(50, (Runnable)this);
            }
        };
        this._shell.getDisplay().timerExec(50, timer);
    }

    @Override
    public void projectModified() {
        this._shell.setText(String.format("CeboMultiLogger %s - (c) 2021 Cesys GmbH - [%s] %s", Global.version(), this._project.getFileName() == null ? "UNNAMED" : this._project.getFileName(), this._project.isModified() ? "*" : ""));
        this._mnuSaveProject.setEnabled(this._project.getFileName() != null);
        if (!this._txtProjectComment.getText().equals(this._project.getProjectComment())) {
            this._txtProjectComment.setText(this._project.getProjectComment());
        }
        this._lblOutputPath.setText(this._project.getOutputPath());
        long free = new File(this._project.getOutputPath()).getFreeSpace();
        long sps = 0L;
        for (IDevice de : this._project.getDevices()) {
            double rate = de.getFrequency();
            if (!(rate > 0.0)) continue;
            long sum = 0L;
            for (ISource so : this._project.getSourcesOfDevice(de)) {
                sum += (long)so.getSampleType().getByteSize();
            }
            sps += (long)(rate * (double)sum);
        }
        long maxDuration = 0L;
        if (sps != 0L) {
            maxDuration = free / sps * 1000L;
        }
        this._lblStats.setText(String.format("%s -- Space: %s, Rate: %s, Max duration: %s", NumberSupport.UI.toDurationString(this._project.getDuration()), NumberSupport.UI.toPrefixString(free, "B"), NumberSupport.UI.toPrefixString(sps, "B/s"), NumberSupport.UI.toDurationString(maxDuration)));
        if (this._project.getDuration() > maxDuration && sps != 0L) {
            this._lblStats.setForeground(SWTResourceManager.getColor(255, 0, 0));
        } else {
            this._lblStats.setForeground(this._shell.getDisplay().getSystemColor(21));
        }
        this._btnAutoExport.setSelection(this._project.isAutoExport());
        this._btnOverwrite.setSelection(this._project.isOverwrite());
        this._cmbvExport.setSelection((ISelection)new StructuredSelection(Arrays.asList(this._project.getExportPlugin()), new IElementComparer(){

            public int hashCode(Object element) {
                return ((IExportPlugin)element).getTypeName().hashCode();
            }

            public boolean equals(Object a, Object b) {
                return ((IExportPlugin)a).getTypeName().equals(((IExportPlugin)b).getTypeName());
            }
        }));
        this._btnConfigExport.setEnabled(this._project.getExportPlugin().hasConfiguration());
    }

    private MainWindow() {
        this._project.addModificationObserver(this);
    }

    public static void main(String[] args) {
        try {
            try {
                Config.INSTANCE.load(Global.INSTANCE.getConfigFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            NumberSupport.UI.setLocaleId(Config.INSTANCE.getLocaleUiId(), Config.INSTANCE.getNumberGroupingUi());
            MainWindow window = new MainWindow();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        Display display = Display.getDefault();
        PluginCentral.INSTANCE.initialize(null);
        Utils.setApplicationId("Cesys.CeboMultiLogger");
        this.createContents();
        this.init();
        this._shell.open();
        this._shell.layout();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContents() {
        this._shell = new Shell();
        this._shell.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/AppIcon.png"));
        this._shell.setSize(1167, 787);
        this._shell.setText("CeboMultiLogger - (c) 2015 Cesys GmbH");
        this._shell.setLayout((Layout)new GridLayout(1, false));
        this._menu = new Menu((Decorations)this._shell, 2);
        this._shell.setMenuBar(this._menu);
        this._mnuProject = new MenuItem(this._menu, 64);
        this._mnuProject.setText("Project");
        this._menu_1 = new Menu(this._mnuProject);
        this._mnuProject.setMenu(this._menu_1);
        this._mnuNewProject = new MenuItem(this._menu_1, 0);
        this._mnuNewProject.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/New document.png"));
        this._mnuNewProject.setText("New Project");
        new MenuItem(this._menu_1, 2);
        this._mnuLoadProject = new MenuItem(this._menu_1, 0);
        this._mnuLoadProject.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Folder.png"));
        this._mnuLoadProject.setText("Load Project ...");
        new MenuItem(this._menu_1, 2);
        this._mnuSaveProject = new MenuItem(this._menu_1, 0);
        this._mnuSaveProject.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Save.png"));
        this._mnuSaveProject.setText("Save Project");
        this._mnuSaveProjectAs = new MenuItem(this._menu_1, 0);
        this._mnuSaveProjectAs.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Save.png"));
        this._mnuSaveProjectAs.setText("Save Project As ...");
        new MenuItem(this._menu_1, 2);
        this._mnuConfig = new MenuItem(this._menu_1, 0);
        this._mnuConfig.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Equipment.png"));
        this._mnuConfig.setText("Configuration ...");
        new MenuItem(this._menu_1, 2);
        this._mnuExit = new MenuItem(this._menu_1, 0);
        this._mnuExit.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Exit.png"));
        this._mnuExit.setText("Exit");
        this._composite = new Composite((Composite)this._shell, 0);
        this._composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this._composite.setLayout((Layout)new GridLayout(2, false));
        this._label = new Label(this._composite, 0);
        this._label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label.setText("Project remark:");
        this._txtProjectComment = new Text(this._composite, 2048);
        this._txtProjectComment.setText("");
        this._txtProjectComment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._composite_2 = new Composite((Composite)this._shell, 0);
        this._composite_2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_composite_2 = new TableColumnLayout();
        this._composite_2.setLayout((Layout)tcl_composite_2);
        this._tblvMain = new TableViewer(this._composite_2, 67584);
        this._tblMain = this._tblvMain.getTable();
        this._tblMain.setLinesVisible(true);
        this._tblMain.setHeaderVisible(true);
        this._tblvcDummy = new TableViewerColumn(this._tblvMain, 0);
        this._tblcDummy = this._tblvcDummy.getColumn();
        tcl_composite_2.setColumnData((Widget)this._tblcDummy, (ColumnLayoutData)new ColumnPixelData(1, false, true));
        this._tblvcName = new TableViewerColumn(this._tblvMain, 0);
        this._tblcName = this._tblvcName.getColumn();
        this._tblcName.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Bubble.png"));
        tcl_composite_2.setColumnData((Widget)this._tblcName, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this._tblcName.setAlignment(0x1000000);
        this._tblcName.setText("Name");
        this._tblvcDevice = new TableViewerColumn(this._tblvMain, 0);
        this._tblcDevice = this._tblvcDevice.getColumn();
        this._tblcDevice.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Hard disk.png"));
        this._tblcDevice.setAlignment(0x1000000);
        tcl_composite_2.setColumnData((Widget)this._tblcDevice, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this._tblcDevice.setText("Device");
        this._tblvcInput = new TableViewerColumn(this._tblvMain, 0);
        this._tblcInput = this._tblvcInput.getColumn();
        tcl_composite_2.setColumnData((Widget)this._tblcInput, (ColumnLayoutData)new ColumnPixelData(80, true, true));
        this._tblcInput.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Next.png"));
        this._tblcInput.setAlignment(0x1000000);
        this._tblcInput.setText("Input");
        this._tblvcRange = new TableViewerColumn(this._tblvMain, 0);
        this._tblcRange = this._tblvcRange.getColumn();
        this._tblcRange.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Up-down.png"));
        this._tblcRange.setAlignment(0x1000000);
        tcl_composite_2.setColumnData((Widget)this._tblcRange, (ColumnLayoutData)new ColumnPixelData(80, true, true));
        this._tblcRange.setText("Range");
        this._tblvcCurrentValue = new TableViewerColumn(this._tblvMain, 0);
        this._tblcCurrentValue = this._tblvcCurrentValue.getColumn();
        this._tblcCurrentValue.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Eye.png"));
        this._tblcCurrentValue.setAlignment(0x1000000);
        tcl_composite_2.setColumnData((Widget)this._tblcCurrentValue, (ColumnLayoutData)new ColumnPixelData(150, true, true));
        this._tblcCurrentValue.setText("Current Value");
        this._tblvcProcessing = new TableViewerColumn(this._tblvMain, 0);
        this._tblcProcessing = this._tblvcProcessing.getColumn();
        this._tblcProcessing.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Mobile-phone.png"));
        this._tblcProcessing.setAlignment(0x1000000);
        tcl_composite_2.setColumnData((Widget)this._tblcProcessing, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this._tblcProcessing.setText("Processing");
        this._composite_1 = new Composite((Composite)this._shell, 0);
        this._composite_1.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this._composite_1.setLayout((Layout)new GridLayout(2, false));
        Group grp = new Group(this._composite_1, 0);
        grp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grp.setLayout((Layout)new GridLayout(3, false));
        grp.setText("Data Acquisition");
        this._btnStart = new Button((Composite)grp, 0);
        GridData gd_btnStart = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnStart.widthHint = 100;
        this._btnStart.setLayoutData((Object)gd_btnStart);
        this._btnStart.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Lightning.png"));
        this._btnStart.setText("Start");
        this._lblOutputPath = new Label((Composite)grp, 0);
        this._lblOutputPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._lblOutputPath.setText("C:\\Users\\bla\\Documents\\My Measures");
        this._btnSelectPath = new Button((Composite)grp, 0);
        this._btnSelectPath.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._btnSelectPath.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Save.png"));
        this._btnDuration = new Button((Composite)grp, 0);
        this._btnDuration.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Clock.png"));
        this._btnDuration.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this._btnDuration.setText("Duration");
        this._lblStats = new Label((Composite)grp, 0);
        this._lblStats.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._lblStats.setText("Stats");
        new Label((Composite)grp, 0);
        this._btnAutoExport = new Button((Composite)grp, 32);
        this._btnAutoExport.setText("Auto Export");
        this._btnOverwrite = new Button((Composite)grp, 32);
        this._btnOverwrite.setText("Overwrite");
        new Label((Composite)grp, 0);
        this._prgRecording = new ProgressBar((Composite)grp, 0);
        this._prgRecording.setMaximum(1000);
        this._prgRecording.setSelection(0);
        this._prgRecording.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this._lblPercent = new Label((Composite)grp, 0x1000000);
        GridData gd_lblPercent = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblPercent.widthHint = 120;
        this._lblPercent.setLayoutData((Object)gd_lblPercent);
        this._lblPercent.setText("0 %");
        Group grp2 = new Group(this._composite_1, 0);
        grp2.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grp2.setLayout((Layout)new GridLayout(3, true));
        grp2.setText("Export");
        this._btnExport = new Button((Composite)grp2, 0);
        GridData gd_btnExport = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnExport.widthHint = 100;
        this._btnExport.setLayoutData((Object)gd_btnExport);
        this._btnExport.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Download.png"));
        this._btnExport.setText("Export");
        this._btnExport.setEnabled(false);
        this._cmbvExport = new ComboViewer((Composite)grp2, 8);
        this._cmbExport = this._cmbvExport.getCombo();
        this._cmbExport.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._btnConfigExport = new Button((Composite)grp2, 0);
        GridData gd_btnConfigExport = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnConfigExport.widthHint = 100;
        this._btnConfigExport.setLayoutData((Object)gd_btnConfigExport);
        this._btnConfigExport.setImage(SWTResourceManager.getImage(MainWindow.class, "/com/cesys/apps/cebomultilogger/resources/Wrench.png"));
        this._btnConfigExport.setText("Configure");
    }

    private static interface IExceptionReporter {
        public void setException(Exception var1);

        public Exception getException();
    }

    private static class ToISourceTransformer
    implements Transformer {
        private ToISourceTransformer() {
        }

        public Object transform(Object input) {
            return input;
        }
    }
}

