/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.plugins.IExportControl;
import com.cesys.apps.cebomultilogger.utils.Utils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

public class ExportProgressDlg
extends Dialog
implements IExportControl {
    private Thread _thread;
    protected Object _result;
    protected Shell _shell;
    private volatile boolean _terminate = false;
    private volatile boolean _complete = false;
    private ProgressBar _progressBar;
    private Label _lblInfo;
    private Button _btnCancel;

    @Override
    public boolean isTerminationRequested() {
        return this._terminate;
    }

    @Override
    public void setTask(final String task) {
        if (this._shell.isDisposed()) {
            return;
        }
        this._shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ExportProgressDlg.this._lblInfo.isDisposed()) {
                    return;
                }
                ExportProgressDlg.this._lblInfo.setText(task);
            }
        });
    }

    @Override
    public void setProgress(final double progress) {
        if (this._shell.isDisposed()) {
            return;
        }
        this._shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ExportProgressDlg.this._progressBar.isDisposed()) {
                    return;
                }
                ExportProgressDlg.this._progressBar.setSelection((int)(1000.0 * progress));
            }
        });
    }

    private void init(Runnable runner) {
        this._shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        this._shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = ExportProgressDlg.this._complete;
            }
        });
        this._btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportProgressDlg.this._terminate = true;
            }
        });
        this._thread = new Thread(runner, "Export thread.");
        this._thread.start();
        Runnable threadPoller = new Runnable(){

            @Override
            public void run() {
                if (ExportProgressDlg.this._shell.isDisposed()) {
                    return;
                }
                if (!ExportProgressDlg.this._thread.isAlive()) {
                    ExportProgressDlg.this._complete = true;
                    ExportProgressDlg.this._shell.close();
                } else {
                    ExportProgressDlg.this._shell.getDisplay().timerExec(50, (Runnable)this);
                }
            }
        };
        this._shell.getDisplay().timerExec(50, threadPoller);
        this._shell.pack();
        Utils.centerOnParent(this._shell, this.getParent());
    }

    public ExportProgressDlg(Shell parent) {
        super(parent, Utils.getDialogStyle());
    }

    public Object open(Runnable runner) {
        this.createContents();
        this.init(runner);
        this._shell.open();
        this._shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this._result;
    }

    private void createContents() {
        this._shell = new Shell(this.getParent(), this.getStyle());
        this._shell.setImage(SWTResourceManager.getImage(ExportProgressDlg.class, "/com/cesys/apps/cebomultilogger/resources/Download.png"));
        this._shell.setSize(614, 112);
        this._shell.setText("Progress");
        this._shell.setLayout((Layout)new GridLayout());
        this._lblInfo = new Label((Composite)this._shell, 0);
        this._lblInfo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this._lblInfo.setText("Export project ...");
        this._progressBar = new ProgressBar((Composite)this._shell, 0);
        this._progressBar.setMaximum(1000);
        GridData gd_progressBar = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_progressBar.widthHint = 400;
        this._progressBar.setLayoutData((Object)gd_progressBar);
        this._btnCancel = new Button((Composite)this._shell, 0);
        this._btnCancel.setImage(SWTResourceManager.getImage(ExportProgressDlg.class, "/com/cesys/apps/cebomultilogger/resources/Cancel.png"));
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = 120;
        this._btnCancel.setLayoutData((Object)gd_btnCancel);
        this._btnCancel.setText("Cancel");
    }
}

