/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.PluginCentral;
import com.cesys.apps.cebomultilogger.Project;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.IDeviceClass;
import com.cesys.apps.cebomultilogger.plugins.NumberSupport;
import com.cesys.apps.cebomultilogger.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class DeviceDialog
extends Dialog {
    protected Object _result;
    private final ArrayList<IDevice> _realDevices = new ArrayList();
    private final Project _project;
    protected Shell _shell;
    private Table _tblAvail;
    private TableViewer _tblvAvail;
    private Table _tblVirtual;
    private TableViewer _tblvVirtual;
    private Button _btnAdd;
    private Button _btnLink;
    private Button _btnCfg;
    private Button _btnUnlink;
    private Button _btnClose;
    private Composite _composite;
    private Composite _composite_1;
    private Composite _composite_2;
    private Composite _composite_3;
    private Composite _composite_4;
    private Composite _composite_5;
    private SashForm _sashForm;
    private Label _label;
    private Label _label_1;
    private TableColumn _tableColumn;
    private TableColumn _tableColumn_1;
    private TableColumn _tableColumn_2;
    private TableColumn _tableColumn_3;
    private TableColumn _tableColumn_4;
    private TableViewerColumn _tableViewerColumn;
    private TableViewerColumn _tableViewerColumn_1;
    private TableViewerColumn _tblvcVirtualName;
    private TableViewerColumn _tableViewerColumn_3;
    private TableViewerColumn _tableViewerColumn_4;
    private Label _lblInfo;
    private TableColumn _tableColumn_5;
    private TableViewerColumn _tableViewerColumn_2;

    private void updateButtonStates() {
        IDevice avail = (IDevice)((IStructuredSelection)this._tblvAvail.getSelection()).getFirstElement();
        IDevice virtual = (IDevice)((IStructuredSelection)this._tblvVirtual.getSelection()).getFirstElement();
        this._btnAdd.setEnabled(avail != null);
        this._btnLink.setEnabled(avail != null && virtual != null && !avail.getSerialNumber().equals("*") && !avail.getSerialNumber().equals(virtual.getSerialNumber()) && avail.getTypeName().equals(virtual.getTypeName()));
        this._btnCfg.setEnabled(virtual != null && virtual.hasConfiguration());
        this._btnUnlink.setEnabled(virtual != null && !virtual.getSerialNumber().equals("*"));
    }

    private String getNextAutoName() {
        int i = 0;
        while (true) {
            String name = "Device " + i;
            boolean found = false;
            for (IDevice d : this._project.getDevices()) {
                if (!d.getName().equals(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                return name;
            }
            ++i;
        }
    }

    private void init() {
        this._tblvAvail.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<IDevice> r = new ArrayList<IDevice>();
                for (IDeviceClass dc : PluginCentral.INSTANCE.getDeviceClasses()) {
                    for (IDevice dev : dc.getSupportedDevices()) {
                        r.add(dev);
                    }
                }
                DeviceDialog dlg = (DeviceDialog)((Object)inputElement);
                r.addAll(dlg._realDevices);
                return r.toArray();
            }
        });
        this._tblvAvail.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                int column = cell.getColumnIndex();
                IDevice e = (IDevice)cell.getElement();
                switch (column) {
                    case 0: {
                        if (e.getSerialNumber().equals("*")) {
                            cell.setText(e.getTypeName() + " (virtual)");
                            break;
                        }
                        cell.setText(e.getTypeName());
                        break;
                    }
                    case 1: {
                        cell.setText(e.getSerialNumber());
                    }
                }
            }
        });
        this._tblAvail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s = (IStructuredSelection)DeviceDialog.this._tblvAvail.getSelection();
                if (s.isEmpty()) {
                    DeviceDialog.this._lblInfo.setText("");
                } else {
                    DeviceDialog.this._lblInfo.setText(((IDevice)s.getFirstElement()).getDescription());
                }
                DeviceDialog.this._shell.layout(true, true);
            }
        });
        this._tblvAvail.setInput((Object)this);
        this._tblvVirtual.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Project)inputElement).getDevices().toArray();
            }
        });
        this._tblvVirtual.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                int column = cell.getColumnIndex();
                IDevice e = (IDevice)cell.getElement();
                switch (column) {
                    case 0: {
                        cell.setText(e.getName());
                        break;
                    }
                    case 1: {
                        cell.setText(e.getTypeName());
                        break;
                    }
                    case 2: {
                        boolean found = false;
                        if (e.getSerialNumber().equals("*")) {
                            found = true;
                        }
                        for (IDevice d : DeviceDialog.this._realDevices) {
                            if (!d.getSerialNumber().equals(e.getSerialNumber())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            cell.setForeground(SWTResourceManager.getColor(255, 0, 0));
                        } else {
                            cell.setForeground(DeviceDialog.this._shell.getDisplay().getSystemColor(24));
                        }
                        cell.setText(e.getSerialNumber());
                        break;
                    }
                    case 3: {
                        if (e.getFrequency() < 0.0) {
                            cell.setText("External");
                            break;
                        }
                        cell.setText(NumberSupport.UI.toUnitString(e.getFrequency(), "Hz"));
                    }
                }
            }
        });
        this._tblvcVirtualName.setEditingSupport(new EditingSupport((ColumnViewer)this._tblvVirtual){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)DeviceDialog.this._tblVirtual);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((IDevice)element).getName();
            }

            protected void setValue(Object element, Object value) {
                IDevice cd = (IDevice)element;
                String nn = (String)value;
                for (IDevice d : DeviceDialog.this._project.getDevices()) {
                    if (d == cd || !nn.equals(d.getName())) continue;
                    Utils.showErrorDialog(DeviceDialog.this._shell, "Name already in use.");
                    return;
                }
                cd.setName(nn);
                DeviceDialog.this._tblvVirtual.update(element, null);
            }
        });
        this._tblvVirtual.setInput((Object)this._project);
        this._btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceDialog.this._shell.close();
            }
        });
        this._btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IDevice dev = (IDevice)((IStructuredSelection)DeviceDialog.this._tblvAvail.getSelection()).getFirstElement();
                if (!dev.getSerialNumber().equals("*")) {
                    for (IDevice d : DeviceDialog.this._project.getDevices()) {
                        if (!d.getSerialNumber().equals(dev.getSerialNumber())) continue;
                        Utils.showErrorDialog(DeviceDialog.this._shell, "Device already in use !");
                        return;
                    }
                } else {
                    dev = dev.cloneInstance();
                }
                dev.setName(DeviceDialog.this.getNextAutoName());
                DeviceDialog.this._project.addDevice(dev);
                DeviceDialog.this._tblvVirtual.refresh();
                DeviceDialog.this.updateButtonStates();
            }
        });
        this._btnLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IDevice dev = (IDevice)((IStructuredSelection)DeviceDialog.this._tblvAvail.getSelection()).getFirstElement();
                IDevice devv = (IDevice)((IStructuredSelection)DeviceDialog.this._tblvVirtual.getSelection()).getFirstElement();
                for (IDevice d : DeviceDialog.this._project.getDevices()) {
                    if (!d.getSerialNumber().equals(dev.getSerialNumber())) continue;
                    Utils.showErrorDialog(DeviceDialog.this._shell, "Device already in use by other instance !");
                    return;
                }
                devv.setSerialNumber(dev.getSerialNumber());
                DeviceDialog.this._tblvVirtual.refresh();
                DeviceDialog.this.updateButtonStates();
            }
        });
        this._btnCfg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDevice devv = (IDevice)((IStructuredSelection)DeviceDialog.this._tblvVirtual.getSelection()).getFirstElement();
                if (devv.configure(DeviceDialog.this._shell)) {
                    DeviceDialog.this._project.modified("Device configuration changed");
                    DeviceDialog.this._tblvVirtual.refresh();
                }
            }
        });
        this._btnUnlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IDevice devv = (IDevice)((IStructuredSelection)DeviceDialog.this._tblvVirtual.getSelection()).getFirstElement();
                devv.setSerialNumber("*");
                DeviceDialog.this._tblvVirtual.refresh();
                DeviceDialog.this.updateButtonStates();
            }
        });
        this.updateButtonStates();
        this._tblAvail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceDialog.this.updateButtonStates();
            }
        });
        this._tblVirtual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceDialog.this.updateButtonStates();
            }
        });
        Runnable enumerator = new Runnable(){

            @Override
            public void run() {
                for (IDeviceClass dc : PluginCentral.INSTANCE.getDeviceClasses()) {
                    ArrayList<IDevice> newDevs = new ArrayList<IDevice>();
                    try {
                        newDevs.addAll(dc.enumerateDevices());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    boolean changed = false;
                    if (newDevs.size() != DeviceDialog.this._realDevices.size()) {
                        changed = true;
                    } else {
                        for (IDevice d0 : newDevs) {
                            boolean found = false;
                            for (IDevice d1 : DeviceDialog.this._realDevices) {
                                if (!d0.getSerialNumber().equals(d1.getSerialNumber())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            changed = true;
                            break;
                        }
                    }
                    if (!changed) continue;
                    DeviceDialog.this._realDevices.clear();
                    DeviceDialog.this._realDevices.addAll(newDevs);
                    if (!DeviceDialog.this._tblAvail.isDisposed()) {
                        DeviceDialog.this._tblvAvail.refresh();
                    }
                    if (DeviceDialog.this._tblVirtual.isDisposed()) continue;
                    DeviceDialog.this._tblvVirtual.refresh();
                }
                if (!DeviceDialog.this._shell.isDisposed()) {
                    DeviceDialog.this._shell.getDisplay().timerExec(250, (Runnable)this);
                }
            }
        };
        this._shell.getDisplay().timerExec(250, enumerator);
        Utils.centerOnParent(this._shell, this.getParent());
    }

    public DeviceDialog(Shell parent, Project project) {
        super(parent, Utils.getDialogStyle());
        this._project = project;
    }

    public Object open() {
        this.createContents();
        this.init();
        this._shell.open();
        this._shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this._result;
    }

    private void createContents() {
        this._shell = new Shell(this.getParent(), this.getStyle());
        this._shell.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Hard disk.png"));
        this._shell.setSize(1070, 602);
        this._shell.setText("Device configuration");
        GridLayout gl_shell = new GridLayout();
        this._shell.setLayout((Layout)gl_shell);
        this._sashForm = new SashForm((Composite)this._shell, 0);
        this._sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this._composite = new Composite((Composite)this._sashForm, 0);
        this._composite.setLayout((Layout)new GridLayout(1, false));
        this._label = new Label(this._composite, 0);
        this._label.setText("Available devices:");
        this._composite_2 = new Composite(this._composite, 0);
        this._composite_2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_composite_2 = new TableColumnLayout();
        this._composite_2.setLayout((Layout)tcl_composite_2);
        this._tblvAvail = new TableViewer(this._composite_2, 67584);
        this._tblAvail = this._tblvAvail.getTable();
        this._tblAvail.setHeaderVisible(true);
        this._tblAvail.setLinesVisible(true);
        this._tableViewerColumn = new TableViewerColumn(this._tblvAvail, 0);
        this._tableColumn = this._tableViewerColumn.getColumn();
        this._tableColumn.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Hard disk.png"));
        tcl_composite_2.setColumnData((Widget)this._tableColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this._tableColumn.setText("Type");
        this._tableViewerColumn_1 = new TableViewerColumn(this._tblvAvail, 0);
        this._tableColumn_1 = this._tableViewerColumn_1.getColumn();
        this._tableColumn_1.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Key.png"));
        tcl_composite_2.setColumnData((Widget)this._tableColumn_1, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this._tableColumn_1.setText("Serial");
        this._lblInfo = new Label(this._composite, 64);
        this._lblInfo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this._composite_3 = new Composite(this._composite, 0);
        this._composite_3.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_composite_3 = new GridLayout(2, true);
        gl_composite_3.marginHeight = 0;
        gl_composite_3.marginWidth = 0;
        this._composite_3.setLayout((Layout)gl_composite_3);
        this._btnAdd = new Button(this._composite_3, 0);
        this._btnAdd.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Create.png"));
        GridData gd_btnAdd = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnAdd.widthHint = 120;
        this._btnAdd.setLayoutData((Object)gd_btnAdd);
        this._btnAdd.setText("Add");
        this._btnLink = new Button(this._composite_3, 0);
        this._btnLink.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Lock.png"));
        this._btnLink.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this._btnLink.setText("Link");
        this._composite_5 = new Composite((Composite)this._sashForm, 0);
        this._composite_5.setLayout((Layout)new GridLayout(1, false));
        this._label_1 = new Label(this._composite_5, 0);
        this._label_1.setText("Selected devices:");
        this._composite_1 = new Composite(this._composite_5, 0);
        this._composite_1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        this._composite_1.setLayout((Layout)tcl_composite_1);
        this._tblvVirtual = new TableViewer(this._composite_1, 67584);
        this._tblVirtual = this._tblvVirtual.getTable();
        this._tblVirtual.setHeaderVisible(true);
        this._tblVirtual.setLinesVisible(true);
        this._tblvcVirtualName = new TableViewerColumn(this._tblvVirtual, 0);
        this._tableColumn_2 = this._tblvcVirtualName.getColumn();
        this._tableColumn_2.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Bubble.png"));
        tcl_composite_1.setColumnData((Widget)this._tableColumn_2, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this._tableColumn_2.setText("Name");
        this._tableViewerColumn_3 = new TableViewerColumn(this._tblvVirtual, 0);
        this._tableColumn_3 = this._tableViewerColumn_3.getColumn();
        this._tableColumn_3.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Hard disk.png"));
        tcl_composite_1.setColumnData((Widget)this._tableColumn_3, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this._tableColumn_3.setText("Type");
        this._tableViewerColumn_4 = new TableViewerColumn(this._tblvVirtual, 0);
        this._tableColumn_4 = this._tableViewerColumn_4.getColumn();
        this._tableColumn_4.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Key.png"));
        tcl_composite_1.setColumnData((Widget)this._tableColumn_4, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        this._tableColumn_4.setText("Serial");
        this._tableViewerColumn_2 = new TableViewerColumn(this._tblvVirtual, 0);
        this._tableColumn_5 = this._tableViewerColumn_2.getColumn();
        tcl_composite_1.setColumnData((Widget)this._tableColumn_5, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this._tableColumn_5.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/oscilloscope.png"));
        this._tableColumn_5.setText("Frequency");
        this._composite_4 = new Composite(this._composite_5, 0);
        this._composite_4.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_composite_4 = new GridLayout(2, true);
        gl_composite_4.marginWidth = 0;
        gl_composite_4.marginHeight = 0;
        this._composite_4.setLayout((Layout)gl_composite_4);
        this._btnCfg = new Button(this._composite_4, 0);
        this._btnCfg.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Wrench.png"));
        this._btnCfg.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this._btnCfg.setText("Configure Device");
        this._btnUnlink = new Button(this._composite_4, 0);
        this._btnUnlink.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Unlock.png"));
        GridData gd_btnUnlink = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnUnlink.widthHint = 120;
        this._btnUnlink.setLayoutData((Object)gd_btnUnlink);
        this._btnUnlink.setText("Unlink");
        this._sashForm.setWeights(new int[]{1, 1});
        this._btnClose = new Button((Composite)this._shell, 0);
        this._btnClose.setImage(SWTResourceManager.getImage(DeviceDialog.class, "/com/cesys/apps/cebomultilogger/resources/Apply.png"));
        GridData gd_btnClose = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnClose.widthHint = 120;
        this._btnClose.setLayoutData((Object)gd_btnClose);
        this._btnClose.setText("Close");
    }
}

