/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.Global;
import com.cesys.apps.cebomultilogger.plugins.IDevice;
import com.cesys.apps.cebomultilogger.plugins.ISource;
import com.cesys.apps.cebomultilogger.plugins.Sample;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeviceDataReader {
    private final IDevice _device;
    private final String _path;
    private final int _devId;
    private final boolean _externalTriggered;
    private final double _frequency;
    private final long _timeStep;
    private final List<Entry> _entryList = new ArrayList<Entry>();
    private BufferedInputStream _bis = null;
    private DataInputStream _dis = null;
    private boolean _eos = false;
    private int _currentChunk = 0;
    private long _currentTimeStamp = 0L;
    private List<Sample> _currentValues = null;

    private boolean grantOpen() throws IOException {
        if (this._bis == null) {
            String fileName = Global.INSTANCE.getDataFileName(this._path, this._devId, this._currentChunk);
            if (!new File(fileName).exists()) {
                return false;
            }
            this._bis = new BufferedInputStream(new FileInputStream(fileName));
            ++this._currentChunk;
        }
        if (this._dis == null) {
            this._dis = new DataInputStream(this._bis);
        }
        return true;
    }

    private void readSet() throws IOException {
        if (this._eos) {
            return;
        }
        if (!this.grantOpen()) {
            this._eos = true;
            return;
        }
        if (this._bis.available() == 0) {
            this.close();
            if (!this.grantOpen()) {
                this._eos = true;
                return;
            }
        }
        if (this._externalTriggered) {
            this._currentTimeStamp = this._dis.readLong();
        }
        this._currentValues = new ArrayList<Sample>();
        for (Entry e : this._entryList) {
            Sample s = null;
            switch (e._type) {
                case STRING: {
                    throw new IOException("String loading not supported");
                }
                case BYTE: {
                    s = new Sample(this._dis.readByte(), e._source.getUnit());
                    break;
                }
                case SHORT: {
                    s = new Sample(this._dis.readShort(), e._source.getUnit());
                    break;
                }
                case INT: {
                    s = new Sample(this._dis.readInt(), e._source.getUnit());
                    break;
                }
                case LONG: {
                    s = new Sample(this._dis.readLong(), e._source.getUnit());
                    break;
                }
                case FLOAT: {
                    s = new Sample(this._dis.readFloat(), e._source.getUnit());
                    break;
                }
                case DOUBLE: {
                    s = new Sample(this._dis.readDouble(), e._source.getUnit());
                }
            }
            s = e._source.getProcessing().transformValue(s, this._currentTimeStamp, this._device, false);
            this._currentValues.add(s);
        }
    }

    DeviceDataReader(String path, IDevice device, int devId) {
        this._path = path;
        this._device = device;
        this._devId = devId;
        this._externalTriggered = true;
        this._frequency = 0.0;
        this._timeStep = 0L;
    }

    DeviceDataReader(String path, IDevice device, int devId, double frequency) {
        this._path = path;
        this._device = device;
        this._devId = devId;
        this._externalTriggered = false;
        this._frequency = frequency;
        this._timeStep = (long)(1.0 / this._frequency * 1000.0 * 1000.0 * 1000.0);
    }

    void appendType(Sample.Type type, int globalIndex, ISource source) {
        this._entryList.add(new Entry(type, globalIndex, source));
    }

    public int mapToGlobalIndex(int i) {
        return this._entryList.get(i)._globalIndex;
    }

    void open() throws IOException {
        this.readSet();
    }

    void close() {
        if (this._dis != null) {
            try {
                this._dis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._dis = null;
            this._bis = null;
        }
    }

    public long getCurrentTimeStamp() {
        return this._currentTimeStamp;
    }

    public List<Sample> getCurrentValues() {
        return this._currentValues;
    }

    public boolean isEOS() {
        return this._eos;
    }

    public void next() throws IOException {
        this.readSet();
        this._currentTimeStamp += this._timeStep;
    }

    private static class Entry {
        private final Sample.Type _type;
        private final int _globalIndex;
        private final ISource _source;

        private Entry(Sample.Type type, int globalIndex, ISource source) {
            this._type = type;
            this._globalIndex = globalIndex;
            this._source = source;
        }
    }
}

