/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Curve2D {
    private ArrayList<Point2D> _points = new ArrayList();
    private boolean _extrapolate = false;

    private void sort() {
        Collections.sort(this._points, new Comparator<Point2D>(){

            @Override
            public int compare(Point2D o1, Point2D o2) {
                return Double.compare(o1.getX(), o2.getX());
            }
        });
    }

    public boolean isExtrapolate() {
        return this._extrapolate;
    }

    public void setExtrapolate(boolean extrapolate) {
        this._extrapolate = extrapolate;
    }

    public void addPoint(Point2D p) {
        this._points.add(p);
        this.sort();
    }

    public double mapXtoY(double value) {
        int last = this._points.size() - 1;
        if (this._points.size() > 1) {
            Point2D p;
            if (!this._extrapolate) {
                if (value <= this._points.get(0).getX()) {
                    return this._points.get(0).getY();
                }
                if (value >= this._points.get(last).getX()) {
                    return this._points.get(last).getY();
                }
            }
            int index = -1;
            int i = 0;
            while (i < this._points.size() && (p = this._points.get(i)).getX() <= value) {
                index = i++;
            }
            if (index == -1) {
                ++index;
            }
            if (index == last) {
                --index;
            }
            Point2D p0 = this._points.get(index);
            Point2D p1 = this._points.get(index + 1);
            double pos = 0.0;
            if (p0.getX() != p1.getY()) {
                pos = (value - p0.getX()) / (p1.getX() - p0.getX());
            }
            return (p1.getY() - p0.getY()) * pos + p0.getY();
        }
        return value;
    }
}

