/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.apps.cebomultilogger;

import com.cesys.apps.cebomultilogger.Config;
import com.cesys.apps.cebomultilogger.Global;
import com.cesys.apps.cebomultilogger.utils.Utils;
import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

public class ConfigDlg
extends Dialog {
    protected boolean _result = false;
    protected Shell _shell;
    private Label _label;
    private Combo _cmbLocale;
    private Button _btnOK;
    private Button _btnCancel;
    private Button _btnNumberGrouping;

    private void init() {
        this._cmbLocale.select(Config.INSTANCE.getLocaleUiId());
        this._btnNumberGrouping.setSelection(Config.INSTANCE.getNumberGroupingUi());
        this._btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Config.INSTANCE.setLocaleUiId(ConfigDlg.this._cmbLocale.getSelectionIndex());
                Config.INSTANCE.setNumberGroupingUi(ConfigDlg.this._btnNumberGrouping.getSelection());
                try {
                    Config.INSTANCE.save(Global.INSTANCE.getConfigFile());
                }
                catch (IOException ex) {
                    Utils.showExceptionBox(ConfigDlg.this._shell, "Error saving configuration.", ex);
                    ConfigDlg.this._shell.close();
                }
                Utils.showInfoDialog(ConfigDlg.this._shell, "Changes become active after application restart.");
                ConfigDlg.this._result = true;
                ConfigDlg.this._shell.close();
            }
        });
        this._shell.pack();
        Utils.centerOnParent(this._shell, this.getParent());
    }

    public ConfigDlg(Shell parent) {
        super(parent, Utils.getDialogStyle());
    }

    public boolean open() {
        this.createContents();
        this.init();
        this._shell.open();
        this._shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this._result;
    }

    private void createContents() {
        this._shell = new Shell(this.getParent(), this.getStyle());
        this._shell.setImage(SWTResourceManager.getImage(ConfigDlg.class, "/com/cesys/apps/cebomultilogger/resources/Equipment.png"));
        this._shell.setSize(450, 124);
        this._shell.setText("Configuration");
        GridLayout gl_shell = new GridLayout();
        gl_shell.numColumns = 3;
        this._shell.setLayout((Layout)gl_shell);
        this._label = new Label((Composite)this._shell, 0);
        this._label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this._label.setText("Locale setting for UI:");
        this._cmbLocale = new Combo((Composite)this._shell, 8);
        this._cmbLocale.setItems(new String[]{"Neutral locale", "Current system locale"});
        this._cmbLocale.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._cmbLocale.select(0);
        new Label((Composite)this._shell, 0);
        this._btnNumberGrouping = new Button((Composite)this._shell, 32);
        this._btnNumberGrouping.setText("Number grouping");
        new Label((Composite)this._shell, 0);
        new Label((Composite)this._shell, 0);
        this._btnOK = new Button((Composite)this._shell, 0);
        this._btnOK.setImage(SWTResourceManager.getImage(ConfigDlg.class, "/com/cesys/apps/cebomultilogger/resources/OK.png"));
        GridData gd_btnOK = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_btnOK.widthHint = 120;
        this._btnOK.setLayoutData((Object)gd_btnOK);
        this._btnOK.setText("OK");
        this._btnCancel = new Button((Composite)this._shell, 0);
        this._btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigDlg.this._shell.close();
            }
        });
        this._btnCancel.setImage(SWTResourceManager.getImage(ConfigDlg.class, "/com/cesys/apps/cebomultilogger/resources/Cancel.png"));
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = 120;
        this._btnCancel.setLayoutData((Object)gd_btnCancel);
        this._btnCancel.setText("Cancel");
    }
}

