/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.utils;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Loader {
    private static Architecture getArchitecture() {
        if (Platform.isWindows() && Platform.is64Bit()) {
            return Architecture.Win64;
        }
        if (Platform.isLinux() && Platform.is64Bit()) {
            if (Platform.isARM()) {
                return Architecture.LinuxAarch64;
            }
            return Architecture.Linux64;
        }
        if (Platform.isMac()) {
            return Architecture.Darwin;
        }
        return Architecture.Unknown;
    }

    public static String prepareLib(String pathStub, String resourceStub, String nameStub) {
        Architecture arch = Loader.getArchitecture();
        String tmpPath = Paths.get(System.getProperty("user.home"), pathStub).toAbsolutePath().toString();
        File path = new File(tmpPath);
        if (!path.exists() && !path.mkdirs()) {
            throw new RuntimeException("Can't create temporary library folder for JNA");
        }
        String outName = arch.getPrefix() + nameStub + arch.getExt();
        Path p = Paths.get(tmpPath, outName).toAbsolutePath();
        if (p.toFile().exists() && !p.toFile().delete()) {
            throw new RuntimeException(String.format("Can't delete existing lib '%s'", p.toString()));
        }
        String src = resourceStub + "/" + arch.getTag() + "/binary";
        try (InputStream is = ClassLoader.getSystemResourceAsStream(src);){
            if (is == null) {
                throw new RuntimeException(String.format("Can't find resource '%s", src));
            }
            Files.copy(is, p, new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.setProperty("jna.library.path", tmpPath);
        Native.register((String)nameStub);
        return nameStub;
    }

    private static native void __wrapper_error(int var0, byte[] var1, int var2, int[] var3);

    public static void checkError(int errorCode) throws IOException {
        if (errorCode != 0) {
            byte[] buffer = new byte[1024];
            int[] kind = new int[1];
            Loader.__wrapper_error(errorCode, buffer, 1024, kind);
            String error = new String(buffer);
            switch (kind[0]) {
                case 128: {
                    throw new IllegalArgumentException(error);
                }
                case 64: {
                    throw new IndexOutOfBoundsException(error);
                }
                case 32: {
                    throw new IllegalStateException(error);
                }
                case 16: {
                    throw new IOException(error);
                }
            }
            throw new RuntimeException("(internal) Unhandled error: " + error);
        }
    }

    public static int toUint32(long value) {
        long maxValue = 0xFFFFFFFFL;
        long minValue = 0L;
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value outside range of 32 bit unsigned int.");
        }
        return (int)value;
    }

    public static long fromUInt32(int value) {
        if (value >= 0) {
            return value;
        }
        return 0x100000000L + (long)value;
    }

    private static enum Architecture {
        Win64("windows", ".dll", ""),
        Linux64("linux-intel", ".so", "lib"),
        LinuxAarch64("linux-aarch64", ".so", "lib"),
        Darwin("darwin", ".dylib", "lib"),
        Unknown("", "", "");

        private final String _tag;
        private final String _ext;
        private final String _prefix;

        public String getTag() {
            return this._tag;
        }

        public String getExt() {
            return this._ext;
        }

        public String getPrefix() {
            return this._prefix;
        }

        private Architecture(String tag, String ext, String prefix) {
            this._tag = tag;
            this._ext = ext;
            this._prefix = prefix;
        }
    }
}

