/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.Input;
import com.cesys.cebomsr.SystemConnector;
import com.cesys.cebomsr.Utils;
import com.cesys.utils.Loader;
import java.io.IOException;

public final class Trigger
implements Input {
    private final Device _device;
    private final int _interfaceId;
    private final int _index;
    private final String _name;

    int getInterfaceId() {
        return this._interfaceId;
    }

    int getIndex() {
        return this._index;
    }

    Trigger(Device device, int interfaceId, int index) throws IOException {
        this._device = device;
        this._interfaceId = interfaceId;
        this._index = index;
        byte[] tmp = new byte[1024];
        Loader.checkError(SystemConnector.CeboMsrGetPeripheralName(device.getHandle(), interfaceId, tmp, 1024));
        this._name = Utils.convertByteArrayToString(tmp);
    }

    public void setEnabled(boolean enable) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrSetTriggerEnable(this._device.getHandle(), this.getInterfaceId(), enable ? 1 : 0));
    }

    public boolean isEnabled() throws IOException {
        int[] r = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetTriggerEnable(this._device.getHandle(), this.getInterfaceId(), r));
        return r[0] != 0;
    }

    public void setConfig(TriggerConfig triggerConfig) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrSetTriggerConfig(this._device.getHandle(), this.getInterfaceId(), triggerConfig._triggerConfigId));
    }

    public TriggerConfig getConfig() throws IOException {
        int[] r = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetTriggerConfig(this._device.getHandle(), this.getInterfaceId(), r));
        return TriggerConfig.getById(r[0]);
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return "Trigger" + this._index;
    }

    public static enum TriggerConfig {
        OutputPulse(-827320064),
        OutputAlternating(-827320063),
        InputRisingEdge(-827320062),
        InputFallingEdge(-827320061),
        InputAlternating(-827320060);

        private final int _triggerConfigId;

        private TriggerConfig(int triggerConfigId) {
            this._triggerConfigId = triggerConfigId;
        }

        static TriggerConfig getById(int id) {
            switch (id) {
                case -827320064: {
                    return OutputPulse;
                }
                case -827320063: {
                    return OutputAlternating;
                }
                case -827320062: {
                    return InputRisingEdge;
                }
                case -827320061: {
                    return InputFallingEdge;
                }
                case -827320060: {
                    return InputAlternating;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

