/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.DeviceType;
import com.cesys.cebomsr.SystemConnector;
import com.cesys.cebomsr.Utils;
import com.cesys.utils.Loader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LibraryInterface {
    private LibraryInterface() {
    }

    public static String getApiVersion() throws IOException {
        byte[] tmp = new byte[1024];
        Loader.checkError(SystemConnector.CeboMsrGetApiVersion(tmp, 1024));
        return Utils.convertByteArrayToString(tmp);
    }

    public static List<Device> enumerate(DeviceType type) throws IOException {
        ArrayList<Device> r = new ArrayList<Device>();
        int[] countb = new int[1];
        Loader.checkError(SystemConnector.CeboMsrBeginEnumerate(countb, type.getInterfaceId()));
        int count = countb[0];
        byte[] ident = new byte[1024];
        int[] msrType = new int[1];
        byte[] version = new byte[1024];
        for (int i = 0; i < count; ++i) {
            Loader.checkError(SystemConnector.CeboMsrGetIdentifier(i, ident, 1024, msrType, version, 1024));
            r.add(new Device(Utils.convertByteArrayToString(ident), DeviceType.getDeviceTypeById(msrType[0]), Utils.convertByteArrayToString(version)));
        }
        return Collections.unmodifiableList(r);
    }
}

