/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.SystemConnector;
import com.cesys.cebomsr.Utils;
import com.cesys.utils.Loader;
import java.io.IOException;

public final class Led {
    private final Device _device;
    private final int _interfaceId;
    private final String _name;

    int getInterfaceId() {
        return this._interfaceId;
    }

    Led(Device device, int interfaceId, int index) throws IOException {
        this._device = device;
        this._interfaceId = interfaceId;
        byte[] tmp = new byte[1024];
        Loader.checkError(SystemConnector.CeboMsrGetPeripheralName(device.getHandle(), interfaceId, tmp, 1024));
        this._name = Utils.convertByteArrayToString(tmp);
    }

    public void setEnabled(boolean enable) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrSetLed(this._device.getHandle(), this.getInterfaceId(), enable ? 1 : 0));
    }

    public String getName() {
        return this._name;
    }
}

