/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

public final class InputFrame {
    private final float[] _analogValues;
    private final int[] _digitalValues;
    private final int _singleEndedOffset;
    private final int _singleEndedCount;
    private final int _differentialOffset;
    private final int _differentialCount;
    private final int _digitalPortOffset;
    private final int _digitalPortCount;
    private final int _counterOffset;
    private final int _counterCount;
    private final int _triggerOffset;
    private final int _triggerCount;

    InputFrame(float[] analogValues, int[] digitalValues, int singleEndedOffset, int singleEndedCount, int differentialOffset, int differentialCount, int digitalPortOffset, int digitalPortCount, int counterOffset, int counterCount, int triggerOffset, int triggerCount) {
        this._digitalValues = digitalValues;
        this._analogValues = analogValues;
        this._singleEndedOffset = singleEndedOffset;
        this._singleEndedCount = singleEndedCount;
        this._differentialOffset = differentialOffset;
        this._differentialCount = differentialCount;
        this._digitalPortOffset = digitalPortOffset;
        this._digitalPortCount = digitalPortCount;
        this._counterOffset = counterOffset;
        this._counterCount = counterCount;
        this._triggerOffset = triggerOffset;
        this._triggerCount = triggerCount;
    }

    public float getSingleEnded(int index) {
        if (index < 0 || index >= this._singleEndedCount) {
            throw new IndexOutOfBoundsException();
        }
        return this._analogValues[this._singleEndedOffset + index];
    }

    public float getDifferential(int index) {
        if (index < 0 || index >= this._differentialCount) {
            throw new IndexOutOfBoundsException();
        }
        return this._analogValues[this._differentialOffset + index];
    }

    public int getDigitalPort(int index) {
        if (index < 0 || index >= this._digitalPortCount) {
            throw new IndexOutOfBoundsException();
        }
        return this._digitalValues[this._digitalPortOffset + index];
    }

    public boolean getTrigger(int index) {
        if (index < 0 || index >= this._triggerCount) {
            throw new IndexOutOfBoundsException();
        }
        return 0 != this._digitalValues[this._triggerOffset + index];
    }

    public long getCounter(int index) {
        if (index < 0 || index >= this._counterCount) {
            throw new IndexOutOfBoundsException();
        }
        return (long)this._digitalValues[this._counterOffset + index] & 0xFFFFFFFFL;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("InputFrame: \n");
        for (i = 0; i < this._singleEndedCount; ++i) {
            sb.append(String.format("SingleEnded #%d = %.2f V \n", i, Float.valueOf(this.getSingleEnded(i))));
        }
        for (i = 0; i < this._differentialCount; ++i) {
            sb.append(String.format("Differential #%d = %.2f V \n", i, Float.valueOf(this.getDifferential(i))));
        }
        for (i = 0; i < this._digitalPortCount; ++i) {
            sb.append(String.format("DigitalPort #%d = %d (0x%02x) \n", i, this.getDigitalPort(i), this.getDigitalPort(i)));
        }
        for (i = 0; i < this._counterCount; ++i) {
            sb.append(String.format("Counter #%d = %d (0x%02x) \n", i, this.getCounter(i), this.getCounter(i)));
        }
        for (i = 0; i < this._triggerCount; ++i) {
            sb.append(String.format("Trigger #%d = %s \n", i, this.getTrigger(i) ? "high" : "low"));
        }
        return sb.toString();
    }
}

