/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.Input;
import com.cesys.cebomsr.Output;
import com.cesys.cebomsr.SystemConnector;
import com.cesys.cebomsr.Utils;
import com.cesys.utils.Loader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DigitalPort
implements Input,
Output {
    private final Device _device;
    private final int _interfaceId;
    private final int _index;
    private final int _ioCount;
    private final String _name;
    private final List<String> _ioNames = new ArrayList<String>();

    int getInterfaceId() {
        return this._interfaceId;
    }

    int getIndex() {
        return this._index;
    }

    DigitalPort(Device device, int interfaceId, int index) throws IOException {
        this._device = device;
        this._interfaceId = interfaceId;
        this._index = index;
        int[] r = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetDigitalPortIoCount(device.getHandle(), this.getInterfaceId(), r));
        this._ioCount = r[0];
        byte[] tmp = new byte[1024];
        Loader.checkError(SystemConnector.CeboMsrGetPeripheralName(device.getHandle(), interfaceId, tmp, 1024));
        this._name = Utils.convertByteArrayToString(tmp);
        for (int i = 0; i < this._ioCount; ++i) {
            Loader.checkError(SystemConnector.CeboMsrGetDigitalPortIoName(device.getHandle(), interfaceId, i, tmp, 1024));
            this._ioNames.add(Utils.convertByteArrayToString(tmp));
        }
    }

    public void setOutputEnableMask(int mask) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrSetDigitalPortOutputEnableMask(this._device.getHandle(), this.getInterfaceId(), mask));
    }

    public int getIoCount() {
        return this._ioCount;
    }

    public int read() throws IOException {
        int[] r = new int[1];
        Loader.checkError(SystemConnector.CeboMsrReadDigitalPort(this._device.getHandle(), this.getInterfaceId(), r));
        return r[0];
    }

    public void write(int value) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrWriteDigitalPort(this._device.getHandle(), this.getInterfaceId(), value));
    }

    public String getName() {
        return this._name;
    }

    public String getIoName(int io) {
        return this._ioNames.get(io);
    }

    public String toString() {
        return "DigitalPort" + this._index;
    }
}

