/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

import com.cesys.cebomsr.AnalogInput;
import com.cesys.cebomsr.AnalogOutput;
import com.cesys.cebomsr.Counter;
import com.cesys.cebomsr.CurrentSource;
import com.cesys.cebomsr.DeviceType;
import com.cesys.cebomsr.DigitalPort;
import com.cesys.cebomsr.Input;
import com.cesys.cebomsr.InputFrame;
import com.cesys.cebomsr.Led;
import com.cesys.cebomsr.Output;
import com.cesys.cebomsr.OutputFrame;
import com.cesys.cebomsr.SystemConnector;
import com.cesys.cebomsr.Trigger;
import com.cesys.cebomsr.Utils;
import com.cesys.utils.Loader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Device {
    private final String _ident;
    private final String _firmwareVersion;
    private final DeviceType _msrType;
    private int _handle = -1;
    private int _maxInputFrames = -1;
    private final List<AnalogInput> _singleEnded = new ArrayList<AnalogInput>();
    private final List<AnalogInput> _differential = new ArrayList<AnalogInput>();
    private final List<AnalogOutput> _analogOutputs = new ArrayList<AnalogOutput>();
    private final List<DigitalPort> _digitalPorts = new ArrayList<DigitalPort>();
    private final List<Counter> _counters = new ArrayList<Counter>();
    private final List<Trigger> _triggers = new ArrayList<Trigger>();
    private final List<Led> _leds = new ArrayList<Led>();
    private final List<CurrentSource> _currentSources = new ArrayList<CurrentSource>();
    public static final int FlagResetInputFifo = 1;

    private int getSingleEndedCount() {
        return this._singleEnded.size();
    }

    private int getDifferentialCount() {
        return this._differential.size();
    }

    private int getAnalogOutputCount() {
        return this._analogOutputs.size();
    }

    private int getDigitalPortCount() {
        return this._digitalPorts.size();
    }

    private int getCounterCount() {
        return this._counters.size();
    }

    private int getTriggerCount() {
        return this._triggers.size();
    }

    private int getInputFrameFloatCount() {
        return this.getSingleEndedCount() + this.getDifferentialCount();
    }

    private int getInputFrameIntCount() {
        return this.getDigitalPortCount() + this.getCounterCount() + this.getTriggerCount();
    }

    private int getOutputFrameFloatCount() {
        return this.getAnalogOutputCount();
    }

    private int getOutputFrameIntCount() {
        return this.getDigitalPortCount();
    }

    private int getMaxInputFrames() {
        return this._maxInputFrames;
    }

    private static int toUint32(long value) {
        long maxValue = 0xFFFFFFFFL;
        long minValue = 0L;
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value outside range of 32 bit unsigned int.");
        }
        return (int)value;
    }

    private static long fromUInt32(int value) {
        if (value >= 0) {
            return value;
        }
        return 0x100000000L + (long)value;
    }

    private List<InputFrame> convertArraysToFrames(float[] vbuffer, int[] buffer, int count) {
        ArrayList<InputFrame> r = new ArrayList<InputFrame>();
        int voffset = 0;
        int offset = 0;
        int i = 0;
        while (i < count) {
            r.add(new InputFrame(vbuffer, buffer, voffset, this.getSingleEndedCount(), voffset + this.getSingleEndedCount(), this.getDifferentialCount(), offset, this.getDigitalPortCount(), offset + this.getDigitalPortCount(), this.getCounterCount(), offset + this.getDigitalPortCount() + this.getCounterCount(), this.getTriggerCount()));
            ++i;
            voffset += this.getInputFrameFloatCount();
            offset += this.getInputFrameIntCount();
        }
        return r;
    }

    private int getDeviceParameter(int param) throws IOException {
        int[] tmp = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetDeviceParameter(this._handle, param, tmp));
        return tmp[0];
    }

    int getHandle() {
        return this._handle;
    }

    Device(String ident, DeviceType msrType, String firmwareVersion) {
        this._ident = ident;
        this._msrType = msrType;
        this._firmwareVersion = firmwareVersion;
    }

    public void open() throws IOException {
        int i;
        int[] handleb = new int[1];
        byte[] id = this._ident.getBytes();
        byte[] idnt = new byte[id.length + 1];
        System.arraycopy(id, 0, idnt, 0, id.length);
        Loader.checkError(SystemConnector.CeboMsrOpen(idnt, handleb));
        this._handle = handleb[0];
        this._singleEnded.clear();
        for (i = 0; i < this.getDeviceParameter(0); ++i) {
            this._singleEnded.add(new AnalogInput(this, -827322112 + i, AnalogInput.Style.SingleEnded, i));
        }
        this._differential.clear();
        for (i = 0; i < this.getDeviceParameter(1); ++i) {
            this._differential.add(new AnalogInput(this, -827321856 + i, AnalogInput.Style.Differential, i));
        }
        this._analogOutputs.clear();
        for (i = 0; i < this.getDeviceParameter(2); ++i) {
            this._analogOutputs.add(new AnalogOutput(this, -827321600 + i, i));
        }
        this._digitalPorts.clear();
        for (i = 0; i < this.getDeviceParameter(3); ++i) {
            this._digitalPorts.add(new DigitalPort(this, -827322368 + i, i));
        }
        this._counters.clear();
        for (i = 0; i < this.getDeviceParameter(4); ++i) {
            this._counters.add(new Counter(this, -827321088 + i, i));
        }
        this._triggers.clear();
        for (i = 0; i < this.getDeviceParameter(5); ++i) {
            this._triggers.add(new Trigger(this, -827320832 + i, i));
        }
        this._currentSources.clear();
        for (i = 0; i < this.getDeviceParameter(7); ++i) {
            this._currentSources.add(new CurrentSource(this, -827320576 + i, i));
        }
        this._leds.clear();
        for (i = 0; i < this.getDeviceParameter(8); ++i) {
            this._leds.add(new Led(this, -827320320 + i, 0));
        }
        this._maxInputFrames = this.getDeviceParameter(6);
    }

    public void close() {
        SystemConnector.CeboMsrClose(this._handle);
        this._handle = -1;
    }

    public void resetDevice() throws IOException {
        Loader.checkError(SystemConnector.CeboMsrResetDevice(this._handle));
    }

    public void resetPeripherals(int mask) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrResetPeripherals(this._handle, mask));
    }

    public String getIdentifier() {
        return this._ident;
    }

    public DeviceType getDeviceType() {
        return this._msrType;
    }

    public String getFirmwareVersion() throws IOException {
        return this._firmwareVersion;
    }

    public String getSerialNumber() throws IOException {
        byte[] tmp = new byte[1024];
        Loader.checkError(SystemConnector.CeboMsrGetSerialNumber(this._handle, tmp, 1024));
        return Utils.convertByteArrayToString(tmp);
    }

    public float getTemperature() throws IOException {
        float[] fb = new float[1];
        Loader.checkError(SystemConnector.CeboMsrGetTemperature(this._handle, fb));
        return fb[0];
    }

    public void setWatchdogTimeout(long timeout250ms) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrSetWatchdogTimeout(this._handle, Loader.toUint32(timeout250ms)));
    }

    public long getWatchdogTimeout() throws IOException {
        int[] to = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetWatchdogTimeout(this._handle, to));
        return Loader.fromUInt32(to[0]);
    }

    public int calculateMaxBufferedInputFrames() throws IOException {
        int[] r = new int[1];
        Loader.checkError(SystemConnector.CeboMsrCalculateMaxBufferedInputFrames(this._handle, r));
        return r[0];
    }

    public void setupInputFrame(Input[] inputs) throws IOException {
        int[] transformed = new int[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] instanceof AnalogInput) {
                transformed[i] = ((AnalogInput)inputs[i]).getInterfaceId();
                continue;
            }
            if (inputs[i] instanceof DigitalPort) {
                transformed[i] = ((DigitalPort)inputs[i]).getInterfaceId();
                continue;
            }
            if (inputs[i] instanceof Trigger) {
                transformed[i] = ((Trigger)inputs[i]).getInterfaceId();
                continue;
            }
            if (inputs[i] instanceof Counter) {
                transformed[i] = ((Counter)inputs[i]).getInterfaceId();
                continue;
            }
            throw new IllegalArgumentException("Unknown input.");
        }
        Loader.checkError(SystemConnector.CeboMsrSetupInputFrame(this._handle, transformed, transformed.length));
    }

    public float startBufferedDataAcquisition(float frameRate, int frameCount, boolean externalStarted) throws IOException {
        float[] r = new float[1];
        if (frameRate <= 0.0f) {
            throw new IllegalArgumentException("frameRate must be > 0");
        }
        if (frameCount <= 0) {
            throw new IllegalArgumentException("frameCount must be > 0");
        }
        Loader.checkError(SystemConnector.CeboMsrStartDataAcquisition(this._handle, externalStarted ? 1 : 0, frameRate, frameCount, r));
        return r[0];
    }

    public void startBufferedExternalTimedDataAcquisition(int frameCount) throws IOException {
        float[] r = new float[1];
        if (frameCount <= 0) {
            throw new IllegalArgumentException("frameCount must be > 0");
        }
        Loader.checkError(SystemConnector.CeboMsrStartDataAcquisition(this._handle, 1, -1.0f, frameCount, r));
    }

    public float startContinuousDataAcquisition(float frameRate, boolean externalStarted) throws IOException {
        float[] r = new float[1];
        if (frameRate <= 0.0f) {
            throw new IllegalArgumentException("frameRate must be > 0");
        }
        Loader.checkError(SystemConnector.CeboMsrStartDataAcquisition(this._handle, externalStarted ? 1 : 0, frameRate, -1, r));
        return r[0];
    }

    public void startContinuousExternalTimedDataAcquisition() throws IOException {
        float[] r = new float[1];
        Loader.checkError(SystemConnector.CeboMsrStartDataAcquisition(this._handle, 1, -1.0f, -1, r));
    }

    public void stopDataAcquisition() throws IOException {
        Loader.checkError(SystemConnector.CeboMsrStopDataAcquisition(this._handle));
    }

    public List<InputFrame> readBlocking(int frameCount) throws IOException {
        float[] vbuffer = new float[this.getInputFrameFloatCount() * frameCount];
        int[] buffer = new int[this.getInputFrameIntCount() * frameCount];
        Loader.checkError(SystemConnector.CeboMsrReadBlocking(this._handle, vbuffer, buffer, frameCount));
        return this.convertArraysToFrames(vbuffer, buffer, frameCount);
    }

    public List<InputFrame> readNonBlocking() throws IOException {
        float[] vbuffer = new float[this.getInputFrameFloatCount() * this.getMaxInputFrames()];
        int[] buffer = new int[this.getInputFrameIntCount() * this.getMaxInputFrames()];
        int[] countb = new int[1];
        Loader.checkError(SystemConnector.CeboMsrReadNonBlocking(this._handle, vbuffer, buffer, countb));
        return this.convertArraysToFrames(vbuffer, buffer, countb[0]);
    }

    public InputFrame readFrame() throws IOException {
        float[] vbuffer = new float[this.getInputFrameFloatCount()];
        int[] buffer = new int[this.getInputFrameIntCount()];
        Loader.checkError(SystemConnector.CeboMsrReadFrame(this._handle, vbuffer, buffer));
        return new InputFrame(vbuffer, buffer, 0, this.getSingleEndedCount(), this.getSingleEndedCount(), this.getDifferentialCount(), 0, this.getDigitalPortCount(), this.getDigitalPortCount(), this.getCounterCount(), this.getDigitalPortCount() + this.getCounterCount(), this.getTriggerCount());
    }

    public void setupOutputFrame(Output[] outputs) throws IOException {
        int[] transformed = new int[outputs.length];
        for (int i = 0; i < outputs.length; ++i) {
            if (outputs[i] instanceof AnalogOutput) {
                transformed[i] = ((AnalogOutput)outputs[i]).getInterfaceId();
                continue;
            }
            if (outputs[i] instanceof DigitalPort) {
                transformed[i] = ((DigitalPort)outputs[i]).getInterfaceId();
                continue;
            }
            throw new IllegalArgumentException("Unknown output.");
        }
        Loader.checkError(SystemConnector.CeboMsrSetupOutputFrame(this._handle, transformed, transformed.length));
    }

    public void writeFrame(OutputFrame frame) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrWriteFrame(this._handle, frame.getAnalogValues(), frame.getDigitalValues()));
    }

    public OutputFrame createOutputFrame() {
        return new OutputFrame(this.getOutputFrameFloatCount(), this.getOutputFrameIntCount());
    }

    public List<AnalogInput> getSingleEndedInputs() {
        return Collections.unmodifiableList(this._singleEnded);
    }

    public List<AnalogInput> getDifferentialInputs() {
        return Collections.unmodifiableList(this._differential);
    }

    public List<AnalogOutput> getAnalogOutputs() {
        return Collections.unmodifiableList(this._analogOutputs);
    }

    public List<DigitalPort> getDigitalPorts() {
        return Collections.unmodifiableList(this._digitalPorts);
    }

    public List<Counter> getCounters() {
        return Collections.unmodifiableList(this._counters);
    }

    public List<Trigger> getTriggers() {
        return Collections.unmodifiableList(this._triggers);
    }

    public List<CurrentSource> getCurrentSources() {
        return Collections.unmodifiableList(this._currentSources);
    }

    public List<Led> getLeds() {
        return Collections.unmodifiableList(this._leds);
    }

    public void readBlock(long address, byte[] buffer) throws IOException {
        this.readBlock(address, buffer, buffer.length);
    }

    public void readBlock(long address, byte[] buffer, int size) throws IOException {
        Loader.checkError(SystemConnector.__CeboMsrReadBlock(this._handle, Device.toUint32(address), buffer, size));
    }

    public long readRegister(long address) throws IOException {
        int[] r = new int[1];
        Loader.checkError(SystemConnector.__CeboMsrReadRegister(this._handle, Device.toUint32(address), r));
        return Device.fromUInt32(r[0]);
    }

    public void writeBlock(long address, byte[] buffer) throws IOException {
        this.writeBlock(address, buffer, buffer.length);
    }

    public void writeBlock(long address, byte[] buffer, int size) throws IOException {
        Loader.checkError(SystemConnector.__CeboMsrWriteBlock(this._handle, Device.toUint32(address), buffer, size));
    }

    public void writeRegister(long address, long value) throws IOException {
        Loader.checkError(SystemConnector.__CeboMsrWriteRegister(this._handle, Device.toUint32(address), Device.toUint32(value)));
    }

    public String toString() {
        return "CeboMsr-Device: " + this._ident;
    }
}

