/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.SystemConnector;
import com.cesys.cebomsr.Utils;
import com.cesys.utils.Loader;
import java.io.IOException;

public final class CurrentSource {
    private final Device _device;
    private final int _interfaceId;
    private final String _name;

    int getInterfaceId() {
        return this._interfaceId;
    }

    CurrentSource(Device device, int interfaceId, int index) throws IOException {
        this._device = device;
        this._interfaceId = interfaceId;
        byte[] tmp = new byte[1024];
        Loader.checkError(SystemConnector.CeboMsrGetPeripheralName(device.getHandle(), interfaceId, tmp, 1024));
        this._name = Utils.convertByteArrayToString(tmp);
    }

    public float getReferenceCurrent() throws IOException {
        float[] r = new float[1];
        Loader.checkError(SystemConnector.CeboMsrGetReferenceCurrent(this._device.getHandle(), this.getInterfaceId(), r));
        return r[0];
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return "CurrentSource: " + this._name;
    }
}

