/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.Input;
import com.cesys.cebomsr.SystemConnector;
import com.cesys.cebomsr.Utils;
import com.cesys.utils.Loader;
import java.io.IOException;

public final class Counter
implements Input {
    private final Device _device;
    private final int _interfaceId;
    private final int _index;
    private final String _name;

    int getInterfaceId() {
        return this._interfaceId;
    }

    int getIndex() {
        return this._index;
    }

    Counter(Device device, int interfaceId, int index) throws IOException {
        this._device = device;
        this._interfaceId = interfaceId;
        this._index = index;
        byte[] tmp = new byte[1024];
        Loader.checkError(SystemConnector.CeboMsrGetPeripheralName(device.getHandle(), interfaceId, tmp, 1024));
        this._name = Utils.convertByteArrayToString(tmp);
    }

    public void reset() throws IOException {
        Loader.checkError(SystemConnector.CeboMsrResetCounter(this._device.getHandle(), this.getInterfaceId()));
    }

    public void setEnabled(boolean enable) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrSetCounterEnable(this._device.getHandle(), this.getInterfaceId(), enable ? 1 : 0));
    }

    public boolean isEnabled() throws IOException {
        int[] r = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetCounterEnable(this._device.getHandle(), this.getInterfaceId(), r));
        return r[0] != 0;
    }

    public void setConfig(CounterConfig counterConfig) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrSetCounterConfig(this._device.getHandle(), this.getInterfaceId(), counterConfig._counterConfigId));
    }

    public CounterConfig getConfig() throws IOException {
        int[] r = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetCounterConfig(this._device.getHandle(), this.getInterfaceId(), r));
        return CounterConfig.getById(r[0]);
    }

    public long read() throws IOException {
        long[] r = new long[1];
        Loader.checkError(SystemConnector.CeboMsrReadCounter(this._device.getHandle(), this.getInterfaceId(), r));
        return r[0];
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return "Counter" + this._index;
    }

    public static enum CounterConfig {
        RisingEdge(-827319808),
        FallingEdge(-827319807),
        Alternating(-827319806);

        private final int _counterConfigId;

        private CounterConfig(int counterConfigId) {
            this._counterConfigId = counterConfigId;
        }

        static CounterConfig getById(int id) {
            switch (id) {
                case -827319808: {
                    return RisingEdge;
                }
                case -827319807: {
                    return FallingEdge;
                }
                case -827319806: {
                    return Alternating;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

