/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.Output;
import com.cesys.cebomsr.Range;
import com.cesys.cebomsr.SystemConnector;
import com.cesys.cebomsr.Utils;
import com.cesys.utils.Loader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AnalogOutput
implements Output {
    private final List<Range> _supportedRanges = new ArrayList<Range>();
    private final Device _device;
    private final int _interfaceId;
    private final int _index;
    private final String _name;

    int getInterfaceId() {
        return this._interfaceId;
    }

    int getIndex() {
        return this._index;
    }

    AnalogOutput(Device device, int interfaceId, int index) throws IOException {
        this._device = device;
        this._interfaceId = interfaceId;
        this._index = index;
        int[] rangeId = new int[1];
        int i = 0;
        while (true) {
            Loader.checkError(SystemConnector.CeboMsrEnumerateRanges(this._device.getHandle(), this.getInterfaceId(), i, rangeId));
            if (rangeId[0] == -827321089) break;
            float[] minValue = new float[1];
            float[] maxValue = new float[1];
            Loader.checkError(SystemConnector.CeboMsrGetRangeMinMax(device.getHandle(), this.getInterfaceId(), rangeId[0], minValue, maxValue));
            this._supportedRanges.add(new Range(rangeId[0], minValue[0], maxValue[0], 0));
            ++i;
        }
        byte[] tmp = new byte[1024];
        Loader.checkError(SystemConnector.CeboMsrGetPeripheralName(device.getHandle(), interfaceId, tmp, 1024));
        this._name = Utils.convertByteArrayToString(tmp);
    }

    public List<Range> getSupportedRanges() {
        return Collections.unmodifiableList(this._supportedRanges);
    }

    public void setParameters(Range range) throws IOException {
    }

    public Range getRange() throws IOException {
        return this._supportedRanges.get(0);
    }

    public void write(float value) throws IOException {
        Loader.checkError(SystemConnector.CeboMsrWriteAnalogOutput(this._device.getHandle(), this.getInterfaceId(), value));
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return "AnalogOutput" + this._index;
    }
}

