/*
 * Decompiled with CFR 0.152.
 */
package com.cesys.cebomsr;

import com.cesys.cebomsr.Device;
import com.cesys.cebomsr.Input;
import com.cesys.cebomsr.Range;
import com.cesys.cebomsr.SystemConnector;
import com.cesys.cebomsr.Utils;
import com.cesys.utils.Loader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AnalogInput
implements Input {
    private final List<Range> _supportedRanges = new ArrayList<Range>();
    private final Device _device;
    private final int _interfaceId;
    private final Style _style;
    private final int _index;
    private final int _minInterChannelDelay;
    private final String _name;

    int getInterfaceId() {
        return this._interfaceId;
    }

    Style getStyle() {
        return this._style;
    }

    int getIndex() {
        return this._index;
    }

    AnalogInput(Device device, int interfaceId, Style style, int index) throws IOException {
        this._device = device;
        this._interfaceId = interfaceId;
        this._style = style;
        this._index = index;
        int[] rangeId = new int[1];
        int i = 0;
        while (true) {
            Loader.checkError(SystemConnector.CeboMsrEnumerateRanges(this._device.getHandle(), this.getInterfaceId(), i, rangeId));
            if (rangeId[0] == -827321089) break;
            float[] minValue = new float[1];
            float[] maxValue = new float[1];
            int[] interChannelDelay = new int[1];
            Loader.checkError(SystemConnector.CeboMsrGetRangeMinMax(device.getHandle(), this.getInterfaceId(), rangeId[0], minValue, maxValue));
            Loader.checkError(SystemConnector.CeboMsrGetDefaultAnalogInputInterChannelDelay(this._device.getHandle(), this.getInterfaceId(), rangeId[0], interChannelDelay));
            this._supportedRanges.add(new Range(rangeId[0], minValue[0], maxValue[0], interChannelDelay[0]));
            ++i;
        }
        int[] micd = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetMinAnalogInputInterChannelDelay(this._device.getHandle(), this.getInterfaceId(), micd));
        this._minInterChannelDelay = micd[0];
        byte[] tmp = new byte[1024];
        Loader.checkError(SystemConnector.CeboMsrGetPeripheralName(device.getHandle(), interfaceId, tmp, 1024));
        this._name = Utils.convertByteArrayToString(tmp);
    }

    public List<Range> getSupportedRanges() {
        return Collections.unmodifiableList(this._supportedRanges);
    }

    public int getDefaultInterChannelDelay(Range range) throws IOException {
        return range.getDefaultInterChannelDelay();
    }

    public int getMinInterChannelDelay() {
        return this._minInterChannelDelay;
    }

    public void setParameters(Range range) throws IOException {
        int[] r = new int[1];
        Loader.checkError(SystemConnector.CeboMsrSetAnalogInputParameters(this._device.getHandle(), this.getInterfaceId(), range.getInterfaceId(), -1, r));
    }

    public int setParameters(Range range, int interChannelDelay) throws IOException {
        int[] r = new int[1];
        Loader.checkError(SystemConnector.CeboMsrSetAnalogInputParameters(this._device.getHandle(), this.getInterfaceId(), range.getInterfaceId(), interChannelDelay, r));
        return r[0];
    }

    public Range getRange() throws IOException {
        int[] g = new int[1];
        int[] st = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetAnalogInputParameters(this._device.getHandle(), this.getInterfaceId(), g, st));
        for (Range range : this._supportedRanges) {
            if (range.getInterfaceId() != g[0]) continue;
            return range;
        }
        throw new IllegalStateException("Invalid range, internal error.");
    }

    public int getInterChannelDelay() throws IOException {
        int[] g = new int[1];
        int[] st = new int[1];
        Loader.checkError(SystemConnector.CeboMsrGetAnalogInputParameters(this._device.getHandle(), this.getInterfaceId(), g, st));
        return st[0];
    }

    public float read() throws IOException {
        float[] r = new float[1];
        Loader.checkError(SystemConnector.CeboMsrReadAnalogInput(this._device.getHandle(), this.getInterfaceId(), r));
        return r[0];
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return Style.Differential == this._style ? "Differential" + this._index : "SingleEnded" + this._index;
    }

    static enum Style {
        SingleEnded,
        Differential;

    }
}

